/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.NodeWrappingAxisIterator;
import net.sf.saxon.tree.iter.NodeWrappingFunction;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.UType;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.located.Located;
import org.jdom2.util.IteratorIterable;

public class JDOM2NodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private JDOM2NodeWrapper parent;
    protected int index;

    private JDOM2NodeWrapper(Object node, JDOM2NodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected static JDOM2NodeWrapper makeWrapper(Object node, JDOM2DocumentWrapper docWrapper) {
        return JDOM2NodeWrapper.makeWrapper(node, docWrapper, null, -1);
    }

    protected static JDOM2NodeWrapper makeWrapper(Object node, JDOM2DocumentWrapper docWrapper, JDOM2NodeWrapper parent, int index) {
        JDOM2NodeWrapper wrapper;
        if (node instanceof Document) {
            wrapper = (JDOM2NodeWrapper)docWrapper.getRootNode();
            if (wrapper == null) {
                wrapper = new JDOM2NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)9;
            }
        } else if (node instanceof Element) {
            wrapper = new JDOM2NodeWrapper(node, parent, index);
            wrapper.nodeKind = 1;
        } else if (node instanceof Attribute) {
            wrapper = new JDOM2NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)2;
        } else if (node instanceof String || node instanceof Text) {
            wrapper = new JDOM2NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)3;
        } else if (node instanceof Comment) {
            wrapper = new JDOM2NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)8;
        } else if (node instanceof ProcessingInstruction) {
            wrapper = new JDOM2NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)7;
        } else {
            if (node instanceof Namespace) {
                throw new IllegalArgumentException("Cannot wrap JDOM namespace objects");
            }
            throw new IllegalArgumentException("Bad node type in JDOM! " + node.getClass() + " instance " + node.toString());
        }
        wrapper.treeInfo = docWrapper;
        return wrapper;
    }

    @Override
    public Object getUnderlyingNode() {
        if (this.node instanceof List) {
            return ((List)this.node).get(0);
        }
        return this.node;
    }

    @Override
    public JDOM2DocumentWrapper getTreeInfo() {
        return (JDOM2DocumentWrapper)this.treeInfo;
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder(this, (SiblingCountingNode)other);
        }
        return -other.compareOrder(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        if (this.node instanceof List) {
            List nodes = (List)this.node;
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (Object node1 : nodes) {
                Text o = (Text)node1;
                fsb.append(JDOM2NodeWrapper.getStringValue(o));
            }
            return fsb;
        }
        return JDOM2NodeWrapper.getStringValue(this.node);
    }

    @Override
    public int getLineNumber() {
        if (this.node instanceof Located) {
            return ((Located)this.node).getLine();
        }
        return -1;
    }

    @Override
    public int getColumnNumber() {
        if (this.node instanceof Located) {
            return ((Located)this.node).getColumn();
        }
        return -1;
    }

    private static String getStringValue(Object node) {
        if (node instanceof Document) {
            List children1 = ((Document)node).getContent();
            FastStringBuffer sb1 = new FastStringBuffer(256);
            JDOM2NodeWrapper.expandStringValue(children1, sb1);
            return sb1.toString();
        }
        if (node instanceof Element) {
            return ((Element)node).getValue();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getValue();
        }
        if (node instanceof Text) {
            return ((Text)node).getText();
        }
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof Comment) {
            return ((Comment)node).getText();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getData();
        }
        if (node instanceof Namespace) {
            return ((Namespace)node).getURI();
        }
        return "";
    }

    private static void expandStringValue(List<Content> list, FastStringBuffer sb) {
        for (Content obj : list) {
            if (obj instanceof Element) {
                sb.append(obj.getValue());
                continue;
            }
            if (obj instanceof Text) {
                sb.append(((Text)obj).getText());
                continue;
            }
            if (obj instanceof EntityRef) {
                throw new IllegalStateException("Unexpanded entity in JDOM2 tree");
            }
            if (!(obj instanceof DocType)) {
                throw new AssertionError((Object)"Unknown JDOM2 node type");
            }
        }
    }

    @Override
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    @Override
    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    @Override
    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    @Override
    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? JDOM2NodeWrapper.makeWrapper(((Element)this.node).getDocument(), this.getTreeInfo()) : JDOM2NodeWrapper.makeWrapper(((Element)this.node).getParent(), this.getTreeInfo());
            } else if (this.node instanceof Text) {
                this.parent = JDOM2NodeWrapper.makeWrapper(((Text)this.node).getParent(), this.getTreeInfo());
            } else if (this.node instanceof Comment) {
                this.parent = JDOM2NodeWrapper.makeWrapper(((Comment)this.node).getParent(), this.getTreeInfo());
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = JDOM2NodeWrapper.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.getTreeInfo());
            } else if (this.node instanceof Attribute) {
                this.parent = JDOM2NodeWrapper.makeWrapper(((Attribute)this.node).getParent(), this.getTreeInfo());
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
                }
                throw new IllegalStateException("Unknown JDOM node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo n;
            AxisIterator iter;
            int ix = 0;
            this.getParent();
            if (this.parent == null) {
                return 0;
            }
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    iter = this.parent.iterateAxis((byte)3);
                    break;
                }
                case 2: {
                    iter = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    iter = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((n = iter.next()) != null) {
                if (n.equals(this)) {
                    this.index = ix;
                    return this.index;
                }
                if (((JDOM2NodeWrapper)n).node instanceof List) {
                    ix += ((List)((JDOM2NodeWrapper)n).node).size();
                    continue;
                }
                ++ix;
            }
            throw new IllegalStateException("JDOM node not linked to parent node");
        }
        return this.index;
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        AttributeEnumeration base = new AttributeEnumeration(this);
        if (nodeTest == AnyNodeTest.getInstance()) {
            return base;
        }
        return new Navigator.AxisFilter(base, nodeTest);
    }

    @Override
    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        if (this.hasChildNodes()) {
            ChildEnumeration base = new ChildEnumeration(this, true, true);
            if (nodeTest == AnyNodeTest.getInstance()) {
                return base;
            }
            return new Navigator.AxisFilter(base, nodeTest);
        }
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean forwards) {
        if (nodeTest == AnyNodeTest.getInstance()) {
            return new ChildEnumeration(this, false, forwards);
        }
        return new Navigator.AxisFilter(new ChildEnumeration(this, false, forwards), nodeTest);
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean includeSelf) {
        IteratorIterable descendants = nodeTest.getUType() == UType.ELEMENT ? ((Parent)this.node).getDescendants((Filter)new ElementFilter()) : ((Parent)this.node).getDescendants();
        NodeWrappingFunction<Content, NodeInfo> wrappingFunct = new NodeWrappingFunction<Content, NodeInfo>(){

            @Override
            public NodeInfo wrap(Content node) {
                return JDOM2NodeWrapper.makeWrapper(node, JDOM2NodeWrapper.this.getTreeInfo());
            }
        };
        AxisIterator wrappedDescendants = new DescendantWrappingIterator<Content>((Iterator<Content>)descendants, wrappingFunct);
        if (includeSelf && nodeTest.matchesNode(this)) {
            wrappedDescendants = new PrependAxisIterator(this, wrappedDescendants);
        }
        if (nodeTest instanceof AnyNodeTest || nodeTest instanceof NodeKindTest && ((NodeKindTest)nodeTest).getNodeKind() == 1) {
            return wrappedDescendants;
        }
        return new Navigator.AxisFilter(wrappedDescendants, nodeTest);
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        if (this.nodeKind == 1) {
            return ((Element)this.node).getAttributeValue(local, uri.equals("http://www.w3.org/XML/1998/namespace") ? Namespace.XML_NAMESPACE : Namespace.getNamespace((String)uri));
        }
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.treeInfo.getRootNode();
    }

    @Override
    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            List addl = elem.getAdditionalNamespaces();
            ArrayList<NamespaceBinding> bindings = new ArrayList<NamespaceBinding>();
            Namespace ns = elem.getNamespace();
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            if (!prefix.isEmpty() || !uri.isEmpty()) {
                bindings.add(new NamespaceBinding(prefix, uri));
            }
            if (!addl.isEmpty()) {
                for (Namespace ns2 : addl) {
                    bindings.add(new NamespaceBinding(ns2.getPrefix(), ns2.getURI()));
                }
            }
            return bindings.toArray(NamespaceBinding.EMPTY_ARRAY);
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.node instanceof Attribute && ((Attribute)this.node).getAttributeType() == Attribute.ID_TYPE;
    }

    @Override
    public boolean isIdref() {
        if (this.node instanceof Attribute) {
            AttributeType type = ((Attribute)this.node).getAttributeType();
            return type == Attribute.IDREF_TYPE || type == Attribute.IDREFS_TYPE;
        }
        return false;
    }

    private final class ChildEnumeration
    implements AxisIterator {
        private JDOM2NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean forwards;

        public ChildEnumeration(JDOM2NodeWrapper start, boolean downwards, boolean forwards) {
            this.forwards = forwards;
            this.commonParent = downwards ? start : (JDOM2NodeWrapper)start.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                Object n = null;
                if (forwards) {
                    for (int i = 0; i <= this.ix; ++i) {
                        n = this.children.next();
                    }
                    if (n instanceof Text) {
                        boolean atEnd = false;
                        while (n instanceof Text) {
                            if (this.children.hasNext()) {
                                n = this.children.next();
                                ++this.ix;
                                continue;
                            }
                            atEnd = true;
                            break;
                        }
                        if (!atEnd) {
                            this.children.previous();
                        }
                    } else {
                        ++this.ix;
                    }
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        @Override
        public JDOM2NodeWrapper next() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object nextChild = this.children.next();
                    if (nextChild instanceof DocType) {
                        return this.next();
                    }
                    if (nextChild instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    if (nextChild instanceof Text) {
                        JDOM2NodeWrapper current = JDOM2NodeWrapper.makeWrapper(nextChild, JDOM2NodeWrapper.this.getTreeInfo(), this.commonParent, this.ix++);
                        ArrayList<Object> list = null;
                        while (this.children.hasNext()) {
                            Object n = this.children.next();
                            if (n instanceof Text) {
                                if (list == null) {
                                    list = new ArrayList<Object>(4);
                                    list.add(current.node);
                                }
                                list.add(n);
                                ++this.ix;
                                continue;
                            }
                            this.children.previous();
                            break;
                        }
                        if (list != null) {
                            current.node = list;
                        }
                        return current;
                    }
                    return JDOM2NodeWrapper.makeWrapper(nextChild, JDOM2NodeWrapper.this.getTreeInfo(), this.commonParent, this.ix++);
                }
                return null;
            }
            if (this.children.hasPrevious()) {
                Object nextChild = this.children.previous();
                if (nextChild instanceof DocType) {
                    return this.next();
                }
                if (nextChild instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                if (nextChild instanceof Text) {
                    JDOM2NodeWrapper current = JDOM2NodeWrapper.makeWrapper(nextChild, JDOM2NodeWrapper.this.getTreeInfo(), this.commonParent, this.ix--);
                    ArrayList<Object> list = null;
                    while (this.children.hasPrevious()) {
                        Object n = this.children.previous();
                        if (n instanceof Text) {
                            if (list == null) {
                                list = new ArrayList<Object>(4);
                                list.add(current.node);
                            }
                            list.add(0, n);
                            --this.ix;
                            continue;
                        }
                        this.children.next();
                        break;
                    }
                    if (list != null) {
                        current.node = list;
                    }
                    return current;
                }
                return JDOM2NodeWrapper.makeWrapper(nextChild, JDOM2NodeWrapper.this.getTreeInfo(), this.commonParent, this.ix--);
            }
            return null;
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator {
        private Iterator<Attribute> atts;
        private int ix = 0;
        private JDOM2NodeWrapper start;

        AttributeEnumeration(JDOM2NodeWrapper start) {
            this.start = start;
            this.atts = ((Element)start.node).getAttributes().iterator();
        }

        @Override
        public JDOM2NodeWrapper next() {
            if (this.atts.hasNext()) {
                return JDOM2NodeWrapper.makeWrapper(this.atts.next(), JDOM2NodeWrapper.this.getTreeInfo(), this.start, this.ix++);
            }
            return null;
        }
    }

    private static class DescendantWrappingIterator<N>
    extends NodeWrappingAxisIterator<N> {
        DescendantWrappingIterator(Iterator<? extends N> descendantIterator, NodeWrappingFunction<? super N, NodeInfo> wrappingFunction) {
            super(descendantIterator, wrappingFunction);
        }

        @Override
        public boolean isIgnorable(Object node) {
            return node instanceof DocType;
        }
    }
}

