/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.response;

import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.ParentState;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistentStateTraceContainer
extends TraceContainer {
    private Map<String, Document> stateTransitions = new HashMap<String, Document>();

    public PersistentStateTraceContainer(Testcase testcase) {
        super(testcase);
    }

    @Override
    public RootObject createRootObject(Element child) {
        return new RootObject(child, this);
    }

    @Override
    public void close(Document responseDoc) throws IOException, TransformerException {
        this.getIOContainer().close();
        this.getTestcase().getTraceFolder().mkdirs();
        for (Map.Entry<String, Document> entry : this.stateTransitions.entrySet()) {
            Document document = entry.getValue();
            this.handleGuards(document);
            DomUtilities.serialize((File)new File(this.getTestcase().getTraceFolder(), entry.getKey() + ".xml"), (Document)document, (boolean)false);
        }
    }

    @Override
    public void addElement(ParentState parentState, Element element) {
        Document document = this.getStateTransitionDocument(parentState);
        Node node = document.importNode(element, true);
        document.getDocumentElement().appendChild(node);
    }

    @Override
    public void addTraceError(Element traceError) {
        Document document = this.getStateTransitionDocument(null);
        Node importedError = document.importNode(traceError, true);
        document.getDocumentElement().appendChild(importedError);
    }

    private Document getStateTransitionDocument(ParentState parentState) {
        String key = parentState == null ? "state.diagram" : parentState.getFilename();
        Document document = this.stateTransitions.get(key);
        if (document == null) {
            document = DomUtilities.newDocument((String)"StateDiagram");
            this.stateTransitions.put(key, document);
        }
        return document;
    }

    private void handleGuards(Document document) {
        try {
            AbstractAsynchronousTestcase testcase = (AbstractAsynchronousTestcase)this.getTestcase();
            String expr = "//event[text()=\"GUARD\"]";
            NodeList nodes = (NodeList)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)expr, (QName)XPathConstants.NODESET);
            int nNodes = nodes.getLength();
            for (int i = 0; i < nNodes; ++i) {
                Element item = (Element)nodes.item(i);
                String objectId = item.getAttribute("objectId");
                String scriptId = testcase.getGuardScript(objectId);
                if (scriptId == null) continue;
                item.setAttribute("scriptId", scriptId);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }
}

