/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.io.Base64Tools;
import ch.e2e.io.FileUtilities;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BlobParameter
extends SimpleTypeParameter {
    private URI sourceURI;

    public BlobParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public BlobParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private BlobParameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
    }

    @Override
    public BlobParameter copy(RecordParameter parent) {
        BlobParameter result = new BlobParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
        byte[] blob = this.getBlob();
        result.setValue(Arrays.copyOf(blob, blob.length));
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.Blob";
    }

    public File getSourceFile() {
        return this.sourceURI == null ? null : new File(this.sourceURI);
    }

    @Override
    public void setValue(Object value) {
        this.sourceURI = null;
        if (value instanceof Value) {
            this.sourceURI = ((Value)value).getSourceURI();
            super.setValue(((Value)value).getData());
        } else if (value instanceof File) {
            File source = (File)value;
            if (source.canRead()) {
                try {
                    this.sourceURI = source.toURI();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    FileUtilities.copy((InputStream)new FileInputStream(source), (OutputStream)out);
                    super.setValue(out.toByteArray());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (value instanceof byte[]) {
            super.setValue(((byte[])value).length == 0 ? null : value);
        } else {
            super.setValue(value);
        }
    }

    @Override
    public boolean importValue(Object value) {
        boolean isValid;
        boolean bl = isValid = value == null || value instanceof File || value instanceof byte[];
        if (isValid) {
            this.setValue(value);
        }
        return isValid;
    }

    @Override
    void setDisplayValue(Object value) {
        super.setDisplayValueUnquoted(value == null ? null : "<html><span style='color:#808080'>" + (this.sourceURI == null ? "Clipboard-content" : this.sourceURI) + "</span></html>");
    }

    public byte[] getBlob() {
        return this.getValue() == null ? new byte[]{} : (byte[])this.getValue();
    }

    @Override
    public boolean importData(Transferable t) {
        boolean imported = false;
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() == 1) {
                    this.setValue(files.get(0));
                    imported = true;
                }
            } else if (t.isDataFlavorSupported(ParameterTransferHandler.blobFlavor)) {
                this.setValue(t.getTransferData(ParameterTransferHandler.blobFlavor));
                imported = true;
            } else if (t.isDataFlavorSupported(ParameterTransferHandler.base64Flavor)) {
                this.setValue(Base64Tools.decodeToBytes((String)((String)t.getTransferData(ParameterTransferHandler.base64Flavor))));
                imported = true;
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.setValue(((String)t.getTransferData(DataFlavor.stringFlavor)).getBytes());
                imported = true;
            }
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException e) {
            System.out.println("importData: I/O exception");
        }
        return imported;
    }

    @Override
    public Transferable createTransferable() {
        return this.isNull() ? null : new ParameterTransferHandler.BlobTransferable((byte[])this.getValue());
    }

    @Override
    Object createValue(Element parameterElement) {
        return new Value(parameterElement.hasAttribute("file") ? URI.create(parameterElement.getAttribute("file")) : null, parameterElement.hasChildNodes() ? Base64Tools.decodeToBytes((String)parameterElement.getFirstChild().getNodeValue()) : new byte[]{});
    }

    @Override
    public Element createParameterElement(Document document) {
        Element parameter = super.createParameterElement(document);
        if (this.sourceURI != null) {
            parameter.setAttribute("file", this.sourceURI.toString());
        }
        return parameter;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new BlobParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
    }

    @Override
    protected Node toSOAP(Document document) {
        return this.createTextNode(document);
    }

    @Override
    protected Node toXML(Document document) {
        return this.createTextNode(document);
    }

    private Node createTextNode(Document document) {
        return document.createTextNode(this.getValue() == null ? "" : Base64Tools.encodeToStringChunked((byte[])((byte[])this.getValue())));
    }

    private static class Value {
        private final URI sourceURI;
        private final byte[] data;

        private Value(URI sourceURI, byte[] data) {
            this.data = data;
            this.sourceURI = sourceURI;
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        public byte[] getData() {
            return this.data == null || this.data.length == 0 ? null : this.data;
        }
    }
}

