/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.Logging;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class TestcaseTemplate {
    protected String operation;
    protected String service;
    protected String location;
    protected String controlUrl;
    protected String fullQualifiedName;
    private File templateFile;

    protected abstract void initialize(Element var1);

    public TestcaseTemplate(Element testcaseTemplate) {
        this.initialize(testcaseTemplate);
    }

    public TestcaseTemplate(File templateFile) {
        this.templateFile = templateFile;
        try {
            Document templateDocument = DomUtilities.parse((File)templateFile, (boolean)false, (boolean)false);
            this.initialize(templateDocument.getDocumentElement());
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "", e);
        }
    }

    public static SoapVersion soapVersion(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        if (attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", "soap12") != null) {
            return SoapVersion.SOAP12;
        }
        if (attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", "soap") != null) {
            return SoapVersion.SOAP11;
        }
        return null;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getService() {
        return this.service;
    }

    public String getLocation() {
        return this.location;
    }

    public String getControlUrl() {
        return this.controlUrl;
    }

    public void setControlUrl(String controlUrl) {
        this.controlUrl = controlUrl;
    }

    void setHome(File home) {
        this.templateFile = new File(home, "template.xml");
    }

    public void write(File templateFile, Element testcaseElement) throws IOException, TransformerException {
        this.templateFile = templateFile;
        Document document = DomUtilities.newDocument();
        testcaseElement = (Element)document.importNode(testcaseElement, true);
        document.appendChild(testcaseElement);
        DomUtilities.serialize((File)this.getTemplateFile(), (Document)document, (boolean)true);
    }

    protected String getAttribute(Element testcaseTemplate, String attributeName) {
        return testcaseTemplate.hasAttribute(attributeName) ? testcaseTemplate.getAttribute(attributeName) : null;
    }

    public static enum SoapVersion {
        SOAP11,
        SOAP12;

    }
}

