/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.trace.request.BearerTokenCredentials;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.request.Request;
import ch.e2e.builder.trace.testcase.response.AbstractResponseParser;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.xml.sax.SAXException;

public abstract class AbstractSynchronousTestcase
extends Testcase {
    private SynchronousTestcaseTemplate template;
    private boolean useCustomLocation = false;
    private String customLocation;
    private String controlUrl;
    private Request request;
    private final Properties properties;
    private File adapterInfoHome;
    private OAuth2Info oAuth2Info = new OAuth2Info(false, null, null);

    public AbstractSynchronousTestcase(String name, SynchronousTestcaseTemplate template, File home) {
        super(name, home, 7);
        this.template = template;
        this.properties = new Properties(new File(home, name + ".testcase"));
        if (this.properties.exists()) {
            this.readProperties();
            this.traceSettings = new TraceSettings(this.properties);
        } else {
            this.createDefaultProperties();
        }
    }

    public abstract AbstractResponseParser getResponseParser();

    @Override
    public void setHome(File newHome) {
        super.setHome(newHome);
        this.properties.setPropertiesFile(new File(this.getHome(), this.properties.getPropertiesFile().getName()));
        if (this.request != null) {
            this.request.setRequestFile(new File(this.getHome(), this.request.getRequestFile().getName()));
        }
    }

    public boolean isOutdated() {
        boolean rtn = false;
        try {
            rtn = this.properties.getBoolean("outdated");
        }
        catch (MissingResourceException e) {
            this.setOutdated(false);
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "getRequestData", e);
        }
        return rtn;
    }

    public void setOutdated(boolean outdated) {
        this.properties.setProperty("outdated", outdated);
        try {
            this.properties.write(false);
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "saveProperties", e);
        }
    }

    public void clearResult() throws FilesNotDeletedException {
        this.clearResultObjects();
    }

    public boolean isUseCustomLocation() {
        return this.useCustomLocation;
    }

    public void setUseCustomLocation(boolean useCustomLocation) {
        this.useCustomLocation = useCustomLocation;
    }

    @Override
    public String getLocation() {
        return this.useCustomLocation && this.customLocation != null ? this.customLocation : this.getDefaultLocation();
    }

    public String getDefaultLocation() {
        return this.template.getLocation();
    }

    public String getCustomLocation() {
        return this.customLocation;
    }

    public void setCustomLocation(String customLocation) {
        String cl;
        this.customLocation = customLocation == null ? null : ((cl = customLocation.trim()).isEmpty() ? null : cl);
    }

    public Credentials getCredentials() {
        if (this.isUseCustomLocation() && this.oAuth2Info.isUse()) {
            return new BearerTokenCredentials(this.getLocation(), this.oAuth2Info.getUsername(), this.oAuth2Info.getPassword());
        }
        return null;
    }

    public OAuth2Info getOAuth2Info() {
        return this.oAuth2Info;
    }

    public boolean setOAuth2Info(OAuth2Info oAuth2Info) {
        if (Objects.equals(this.oAuth2Info, oAuth2Info)) {
            return false;
        }
        this.oAuth2Info = oAuth2Info;
        return true;
    }

    public String getControlUrl() {
        return this.controlUrl;
    }

    public void setControlUrl(String controlUrl) {
        this.controlUrl = controlUrl;
    }

    public String getSoapAction() {
        return this.template.getSoapAction();
    }

    public String getPorttype() {
        return this.template.getPorttype();
    }

    @Override
    public boolean isRPCEncoding() {
        return this.template.isRPCEncoding();
    }

    @Override
    public String getWsdlFolderPath() {
        TestcaseContainer wsdlFolder = null;
        for (TestcaseContainer parent = this.getParent(); parent != null && wsdlFolder == null; parent = parent.getParent()) {
            if (!(parent instanceof AbstractWSDLFolder)) continue;
            wsdlFolder = (AbstractWSDLFolder)parent;
        }
        return wsdlFolder == null ? null : wsdlFolder.getName();
    }

    @Override
    public Request getRequest() throws IOException, SAXException, ParserConfigurationException {
        if (this.request == null) {
            this.loadRequest();
        }
        return this.request;
    }

    @Override
    public void saveRequest() {
        this.saveRequest(false);
    }

    public void saveRequest(boolean forced) {
        if (this.request != null) {
            try {
                this.request.save(forced);
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(this.getClass().getName(), "saveRequest", e);
            }
        }
    }

    public File getAdapterInfoHome() {
        return this.adapterInfoHome == null ? this.getHome().getParentFile() : this.adapterInfoHome;
    }

    public void setAdapterInfoHome(File adapterInfoHome) {
        this.adapterInfoHome = adapterInfoHome;
    }

    public File getRequestFile() {
        return new File(this.home, this.getName() + ".request");
    }

    @Override
    public String getRequestData() throws IOException {
        StringWriter out = new StringWriter();
        try {
            FileUtilities.copy((Reader)this.read(this.getRequestFile()), (Writer)out);
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "getRequestData", e);
            throw e;
        }
        return out.toString();
    }

    public void setRequestData(String data) throws IOException {
        try {
            FileUtilities.copy((Reader)new StringReader(data), (Writer)this.write(this.getRequestFile()));
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "setRequest", e);
            throw e;
        }
    }

    @Override
    public long requestLastModified() {
        return this.getRequestFile().lastModified();
    }

    public void setResponse(SOAPResponse response) {
        this.setResponse(response, true);
    }

    @Override
    public long responseLastModified() {
        return this.getResponseFile().lastModified();
    }

    public void setResponse(SOAPResponse response, boolean saveProperties) {
        if (this.responseWatches != null) {
            this.responseWatches.clear();
            this.responseWatches = null;
        }
        this.removeInspectionListeners();
        try {
            this.getResponseFile().delete();
            AbstractResponseParser responseParser = this.getResponseParser();
            responseParser.parse(response, this);
            this.setUmlTree(responseParser.getUmlTree());
            this.status = response.getMockInfo() != null ? (responseParser.responseHasErrors() ? 44 : (this.getUmlTree() != null && this.getUmlTree().hasTraceError() ? 45 : 42)) : (responseParser.responseHasErrors() ? 8 : (this.getUmlTree() != null && this.getUmlTree().hasTraceError() ? 10 : 6));
            this.watches.clear();
            this.lastRunDate = responseParser.getLastRunDate();
            if (saveProperties) {
                this.saveLastRunDate();
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "setResponse", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
    }

    public File getAdapterOutputsFile() {
        return new File(this.home, this.getName() + ".adapters");
    }

    public Properties getHttpHeaders() {
        return new Properties(new File(this.home, this.getName() + ".httpheader"));
    }

    public File getHttpHeadersFile() {
        return new File(this.home, this.getName() + ".httpheader");
    }

    public void renameTo(String newName) {
        File adapterOutputsFile;
        File newTestcaseFile = new File(this.home, newName + ".testcase");
        this.properties.getPropertiesFile().renameTo(newTestcaseFile);
        this.properties.setPropertiesFile(newTestcaseFile);
        File httpHeadersFile = this.getHttpHeaders().getPropertiesFile();
        if (httpHeadersFile != null && httpHeadersFile.exists()) {
            File newHttpHeadersFile = new File(this.home, newName + ".httpheader");
            httpHeadersFile.renameTo(newHttpHeadersFile);
        }
        File newRequestFile = new File(this.home, newName + ".request");
        this.getRequestFile().renameTo(newRequestFile);
        if (this.request != null) {
            this.request.setRequestFile(newRequestFile);
        }
        if ((adapterOutputsFile = this.getAdapterOutputsFile()).exists()) {
            File newAdapterOutputsFile = new File(this.home, newName + ".adapters");
            adapterOutputsFile.renameTo(newAdapterOutputsFile);
            if (this.request != null) {
                this.request.setAdapterOutputsFile(newAdapterOutputsFile);
            }
        }
        File newTraceFolder = new File(this.home, ".$" + newName + ".trace");
        File traceFolder = this.getTraceFolder();
        if (traceFolder.exists() && !traceFolder.renameTo(newTraceFolder)) {
            String warning = String.format("Renaming of folder '%s' to '%s' failed.", traceFolder.getName(), newTraceFolder.getName());
            logger.warning(warning);
            EventController.fire((EventObject)new SendWarningEvent((Object)this, warning));
        }
        File newGraphFolder = new File(this.home, ".$" + newName + ".graph");
        File graphFolder = this.getGraphFolder();
        if (graphFolder.exists() && !graphFolder.renameTo(newGraphFolder)) {
            String warning = String.format("Renaming of folder '%s' to '%s' failed.", graphFolder.getName(), newGraphFolder.getName());
            logger.warning(warning);
            EventController.fire((EventObject)new SendWarningEvent((Object)this, warning));
        }
        this.requestLog.renameTo(newTraceFolder);
        this.responseLog.renameTo(newTraceFolder);
        this.setName(newName);
    }

    @Override
    public boolean isLeaf() {
        return this.getStatus() == 7 || this.getChildCount() == 0;
    }

    public SynchronousTestcaseTemplate getTemplate() {
        return this.template;
    }

    public boolean hasAdapterTemplates() {
        return new File(this.getHome().getParentFile(), "adapter.template.ids").exists();
    }

    void setTemplate(SynchronousTestcaseTemplate template) {
        this.template = template;
        if (this.request != null) {
            this.request.update(template.getRequestTemplate(), template.isRPCEncoding());
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void saveProperties() {
        try {
            this.fillProperties();
            this.properties.write(false);
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "saveProperties", e);
        }
        this.saveLastRunDate();
    }

    protected void fillProperties() {
        this.properties.setProperty("description", this.description);
        if (this.getLocation() == null) {
            this.properties.removeProperty("location");
        } else {
            this.properties.setProperty("location", this.getLocation());
        }
        if (this.customLocation == null) {
            this.properties.removeProperty("location.custom");
        } else {
            this.properties.setProperty("location.custom", this.customLocation);
        }
        if (this.getOAuth2Info().isUse()) {
            this.properties.setProperty("use.oauth2", true);
        } else {
            this.properties.removeProperty("use.oauth2");
        }
        if (this.getOAuth2Info().getUsername() == null || this.getOAuth2Info().getUsername().isEmpty()) {
            this.properties.removeProperty("oauth2.user");
        } else {
            this.properties.setProperty("oauth2.user", this.getOAuth2Info().getUsername());
        }
        if (this.getOAuth2Info().getPassword() == null || this.getOAuth2Info().getPassword().isEmpty()) {
            this.properties.removeProperty("oauth2.password");
        } else {
            this.properties.setProperty("oauth2.password", Base64.getEncoder().encodeToString(this.getOAuth2Info().getPassword().getBytes(StandardCharsets.UTF_8)));
        }
        this.properties.removeProperty("status");
        this.properties.removeProperty("last.run.date");
        this.properties.setProperty("request.timeout", (long)this.getTimeout());
        this.traceSettings.write();
    }

    public void saveLastRunDate() {
        Properties runDateProperties = new Properties(new File(this.getTraceFolder(), ".lastRunDate"));
        runDateProperties.setProperty("status", (long)this.status);
        if (this.lastRunDate == -1L) {
            runDateProperties.removeProperty("last.run.date");
        } else {
            runDateProperties.setProperty("last.run.date", this.lastRunDate);
        }
        try {
            runDateProperties.write(false);
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "saveLastRunDate", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
    }

    protected Properties getProperties() {
        return this.properties;
    }

    @Override
    protected void createDefaultProperties() {
        try {
            this.description = "";
            this.properties.setProperty("description", this.description);
            this.properties.setProperty("location", this.template.getLocation());
            if (this.template.getControlUrl() != null) {
                this.controlUrl = this.template.getControlUrl();
                this.properties.setProperty("control.url", this.controlUrl);
            }
            this.status = 7;
            this.properties.setProperty("status", (long)this.status);
            this.traceSettings = new TraceSettings(this.properties);
            this.lastRunDate = -1L;
            this.setTimeout(180);
            this.properties.setProperty("request.timeout", (long)this.getTimeout());
            this.properties.setProperty("outdated", false);
            this.properties.write(false);
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "createDefaultProperties", e);
        }
    }

    @Override
    public String getResponseData() {
        String data = null;
        try {
            File file = this.getDocumentEncodedResponseFile();
            if (file.exists()) {
                StringWriter out = new StringWriter();
                FileUtilities.copy((Reader)this.read(file), (Writer)out);
                data = out.toString();
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "getResponseData", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
        return data;
    }

    public File getDocumentEncodedResponseFile() {
        return new File(this.getTraceFolder(), "response.doc.encoded");
    }

    @Override
    public boolean loadUmlTreeFromDisk() {
        boolean loaded = false;
        try {
            this.setUmlTree(UmlObjectFactory.createUmlTree(this.getTraceFolder()));
            UmlTree umlTree = this.getUmlTree();
            boolean bl = loaded = umlTree != null;
            if (loaded) {
                this.traceSettings.checkInspection(umlTree);
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "checkUmlTree", e);
        }
        return loaded;
    }

    private void loadRequest() throws IOException, ParserConfigurationException, SAXException {
        try {
            this.request = new Request(this.getRequestFile(), this.getAdapterOutputsFile(), this.template.getRequestTemplate(), this.template.isRPCEncoding());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(this.getClass().getName(), "loadRequest", e);
            throw e;
        }
    }

    private void readProperties() {
        this.description = this.properties.getString("description", "");
        String location = this.properties.getString("location", this.template.getLocation()).trim();
        try {
            this.setCustomLocation(this.properties.getString("location.custom"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.setUseCustomLocation(this.customLocation != null && this.customLocation.equals(location) && !this.customLocation.equals(this.getDefaultLocation()));
        String encodedPassword = this.properties.getString("oauth2.password", null);
        String password = null;
        if (encodedPassword != null) {
            try {
                password = new String(Base64.getDecoder().decode(encodedPassword), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setOAuth2Info(new OAuth2Info(this.properties.getBoolean("use.oauth2", false), this.properties.getString("oauth2.user", null), password));
        this.setTimeout((int)this.properties.getInteger("request.timeout", 180L));
        Properties runDateProperties = new Properties(new File(this.getTraceFolder(), ".lastRunDate"));
        this.lastRunDate = runDateProperties.containsKey((Object)"last.run.date") ? runDateProperties.getInteger("last.run.date", -1L) : this.properties.getInteger("last.run.date", -1L);
        this.status = runDateProperties.containsKey((Object)"status") ? (int)runDateProperties.getInteger("status", 7L) : (int)this.properties.getInteger("status", 7L);
    }

    public static class OAuth2Info {
        private final boolean use;
        private final String username;
        private final String password;

        public OAuth2Info(boolean use, String username, String password) {
            this.use = use;
            this.username = username;
            this.password = password;
        }

        public boolean isUse() {
            return this.use;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuth2Info that = (OAuth2Info)o;
            return this.use == that.use && Objects.equals(this.username, that.username);
        }

        public int hashCode() {
            return Objects.hash(this.use, this.username);
        }
    }
}

