/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.crypto.CryptographyFactory;
import ch.e2e.crypto.Encrypt;
import ch.e2e.xuml.substitutor.PlaceholderSubsitutorFactory;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateConstants;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RepositoryTemplate
implements Template {
    private static final String WSDL_PATH_PART = "wsdl/";
    private final ZipFile repository;
    private final String name;
    private final File targetFile;
    private final PlaceholderSubstitutor substitutor;
    private ZipEntry templateEntry;
    private final boolean encryptOutput;

    public RepositoryTemplate(ZipFile repository, String templateName, File targetFile) throws TemplateProcessingException {
        this.repository = repository;
        this.name = templateName;
        this.targetFile = targetFile;
        this.templateEntry = repository.getEntry(templateName);
        if (this.templateEntry == null) {
            throw new TemplateProcessingException("Template '" + templateName + "' not found in repository '" + repository.getName() + "'.");
        }
        this.encryptOutput = templateName.startsWith(WSDL_PATH_PART);
        this.substitutor = PlaceholderSubsitutorFactory.getSubstitutor(templateName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PlaceholderSubstitutor getPlaceholderSubstitutor() {
        return this.substitutor;
    }

    @Override
    public File getTargetFile() {
        return this.targetFile;
    }

    @Override
    public Reader getReader() throws TemplateProcessingException {
        try {
            return new InputStreamReader(this.getInputStream(), TemplateConstants.UTF_8_CHARSET);
        }
        catch (IOException e) {
            throw new TemplateProcessingException(e);
        }
    }

    private InputStream getInputStream() throws IOException {
        return this.repository.getInputStream(this.templateEntry);
    }

    @Override
    public Writer getWriter() throws TemplateProcessingException {
        this.getTargetFile().getParentFile().mkdirs();
        try {
            OutputStream out = this.encryptOutput ? this.getEncryptedOutputStream() : this.getOutputStream();
            return new OutputStreamWriter(out, TemplateConstants.UTF_8_CHARSET);
        }
        catch (IOException e) {
            throw new TemplateProcessingException(e);
        }
    }

    private OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.getTargetFile());
    }

    private OutputStream getEncryptedOutputStream() throws IOException {
        Encrypt encrypt = CryptographyFactory.getEncryption((String)"e2ecrypt01");
        return encrypt.getCipherOutputStream(this.getOutputStream());
    }
}

