/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class NotExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasSpaceAfterNot;
    private String identifier;

    public NotExpression(AbstractExpression parent) {
        super(parent, "NOT");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("NOT"));
        if (this.hasSpaceAfterNot) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.expression != null && this.expression.isAncestor(expression)) {
            return this.getQueryBNF("conditional_primary");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("conditional_primary");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasSpaceAfterNot() {
        return this.hasSpaceAfterNot;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.startsWithIdentifier("AND") || wordParser.startsWithIdentifier("OR") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("NOT");
        this.hasSpaceAfterNot = wordParser.skipLeadingWhitespace() > 0;
        this.expression = this.parse(wordParser, "conditional_primary", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpaceAfterNot) {
            writer.append(' ');
        }
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
    }
}

