function testSerializer() {
	var envelope = new E2E_XMLElementNode('soap:Envelope');
	envelope.appendNamespace("'xmlns:ns1='http://e2e.ch/example/ajax'");
	envelope.appendNamespace("xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
	envelope.appendNamespace("xmlns:xsd='http://www.w3.org/2001/XMLSchema'");
	envelope.appendNamespace("xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/'");
	
	var body = new E2E_XMLElementNode('soap:Body');
	body.setValue('T E S T');
	var attribute = new E2E_XMLAttributeNode('test', 'test');
	body.appendAttribute(attribute);
	 
	envelope.appendChildElement(body);
	alert(envelope.serialize());
}

function testElementParsing() {
	var xml = "<blah><ns0:abc myA='myAVal' ns0:a2='hmm' xmlns:ns0='http://a.b.c/d'>gugus</ns0:abc></blah>";
	
	var e2eResponse = new E2E_XMLResponse(xml);
	
	document.write("<b>Result:</b><br/>");
	
	var element = e2eResponse.getElements("blah")[0];
	document.write("Element: " + element.nodeName + "<br/>");
	
	var namespacedElement = e2eResponse.getElements("abc", "http://a.b.c/d")[0];
	document.write("Namespaced Element: " + namespacedElement.childNodes[0].nodeValue + "<br/>");
	
	var namespacedAttribute = e2eResponse.getAttribute(namespacedElement, "a2", "http://a.b.c/d");
	document.write("Namespaced Attribute: " + namespacedAttribute.nodeValue + "<br/>");
	
	var attribute = e2eResponse.getAttribute(namespacedElement, "myA");
	document.write("Attribute: " + attribute.nodeValue + "<br/>");
}
