import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { NotificationService } from '@pas/app-core';
import { ProcessService } from '@pas/xuml-communication';
import {combineLatest} from 'rxjs';
import { filter } from 'rxjs/operators';

@Component({
  templateUrl: './instance.component.html'
})
export class InstanceComponent implements OnInit {
  private navigationEndSub = null;
  public processName = '';
  public instanceId = '';
  public overviewLink: string;
  public tasks: string[] = [];
  private timeout: any;

  constructor(
      private route: ActivatedRoute,
      private router: Router,
      private process: ProcessService,
      private notification: NotificationService
  ) {
    this.router.onSameUrlNavigation = 'reload';
  }

  ngOnInit() {
    this.route.parent.url.subscribe(segments =>  {
      this.overviewLink = segments.join('');
    });
    combineLatest([
          this.route.params,
          this.route.data
        ]
    ).subscribe(data => {
      const merged = {...data[0], ...data[1]};
      this.processName = merged.processName;
      this.instanceId = merged.instanceId;
      this.tasks = merged.instance.value._meta.currentTasks;

      this.overviewLink = this.router.createUrlTree([this.processName]).toString();
    });

    this.timeoutReloadInstance();
    this.navigationEndSub = this.router.events
        .pipe(filter(event => event instanceof NavigationEnd))
        .subscribe((event) => {
          this.timeoutReloadInstance();
        });
  }

  timeoutReloadInstance() {
    // refresh page after 2 seconds
    this.timeout = setTimeout(() => {
      this.reloadInstance();
    }, 2000);
  }

  async reloadInstance() {
    try {
      await this.router.navigate([this.processName, this.instanceId],
          {
            replaceUrl: true
          });
    } catch (error) {
      this.notification.sendError(error.message);
      await this.router.navigate([this.processName]);
    }
  }

  ngOnDestroy() {
    // turn off the reload timer
    clearTimeout(this.timeout);
    if (this.navigationEndSub) {
      this.navigationEndSub.unsubscribe();
    }
  }
}
