import {OnInit, Component} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {DataListComponentObject, DataTableComponentAction} from "@pas/form-elements";
import {SecurityService} from "@pas/app-core";

interface ProcessInterface {
  processName: string,
  startEvents: string[]
}

@Component({
  selector: 'app-process-list',
  templateUrl: './process-list.component.html'
})
export class ProcessListComponent implements OnInit {

  public processes: DataListComponentObject[] = [];

  constructor(
      private route: ActivatedRoute,
      private router: Router,
      private security: SecurityService
  ) {}

  ngOnInit() {
    this.route.data.subscribe((data: { processes: ProcessInterface[] }) => {
      this._initProcesses(data.processes);
    });
  }

  private _initProcesses(data: ProcessInterface[]): void {
    const processes: DataListComponentObject[] = [];
    for (const process of data) {
      const p : DataListComponentObject = {
        key: process.processName,
        label:process.processName, /* integrate translation here */
        icon: 'subdirectory_arrow_right', /* add custom icon here */
        actions: []
      }

      const resourceId = "process/" + process.processName;
      if (this.security.isAuthorized(resourceId, "instanceList")) {
        p.actions.push({ key: process.processName, icon: 'search'});
      }

      if(process.startEvents) {
        let startActions: DataTableComponentAction[] = [];
        process.startEvents.forEach(key => {
          const resourceId = "process/" + process.processName + "/" + key;
          if (this.security.isAuthorized(resourceId, "write")) {
            startActions.push({key: process.processName + "/" + key, label: key, icon: 'arrow_right_alt'});
          }
        });
        if (startActions.length > 0) {
          p.actions.push({
            key: 'startEvents',
            icon: 'add',
            actions: startActions
          });
        }
      }
      if(p.actions.length > 0) {
        processes.push(p);
      }
    }
    this.processes = processes;
  }

  private _navigateTo(process): void {
    this.router.navigate(['/' + process]);
  }

  public onAction(event): void {
    this._navigateTo(event.key);
  }
}
