<?xml version="1.0" encoding="UTF-8"?>

<!--
  ~ Copyright: Scheer PAS
  -->
<xsl:transform version="2.0"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:xs="http://www.w3.org/2001/XMLSchema"
               exclude-result-prefixes="#all">

    <!-- 	========================================================================================
        Format output
        ======================================================================================== -->
    <xsl:output method="xml" indent="yes"/>

    <!-- 	========================================================================================
        Root
        ======================================================================================== -->
    <xsl:template match="Settings">
        <overrides>
            <xsl:attribute name="version" select="'2.0'"/>

            <xsl:for-each-group select="OverrideSet/Override" group-by="@id">
                <xsl:apply-templates select="current-group()" mode="generate">
                    <xsl:with-param name="isDuplicate" select="count(current-group()) > 1" as="xs:boolean"/>
                </xsl:apply-templates>
            </xsl:for-each-group>
        </overrides>
    </xsl:template>

    <!-- 	========================================================================================
        Rename duplicate IDs.
        ======================================================================================== -->

    <xsl:template match="Override" mode="generate">
        <xsl:param name="isDuplicate" as="xs:boolean"/>
        <default>
            <xsl:attribute name="id" select="if($isDuplicate) then concat(@id, '_', ../@id) else @id"/>
            <xsl:attribute name="value" select="@value"/>
        </default>
    </xsl:template>

</xsl:transform>
