/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class TransactionLogRequest
extends TransactionLogObject {
    private String id;
    private String name;
    private String transactionId;
    private Date startDate;
    private Date endDate;
    private int start;
    private int end;
    private List<TransactionLogEntry> entries = new ArrayList<TransactionLogEntry>();
    private int numberOfCalls = 0;
    private int numberOfFailedCalls;
    private String port;
    private String call;
    private boolean finished = false;
    private static final Pattern PATTERN = Pattern.compile("\\.");

    public TransactionLogRequest(String id) {
        this.id = id;
        int index = id.indexOf(46);
        this.name = index == -1 ? id : id.substring(0, index);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public int getStartTime() {
        return this.start;
    }

    public int getEndTime() {
        return this.end;
    }

    public int getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    public Date getStart() {
        return this.startDate;
    }

    public Date getEnd() {
        return this.endDate;
    }

    public long getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public long getNumberOfFailedCalls() {
        return this.numberOfFailedCalls;
    }

    public String getPort() {
        return this.port;
    }

    public String getCall() {
        return this.call;
    }

    public List<TransactionLogEntry> getEntries() {
        return this.entries;
    }

    public TransactionLogEntry getEntry(int index) {
        return this.getEntries().get(index);
    }

    void addEntry(TransactionLogEntry entry) {
        if (entry != null) {
            this.entries.add(entry);
            entry.setParent(this);
            String string = this.transactionId = entry.getTransactionId() == null ? entry.getRequestId() : entry.getTransactionId();
            if (this.entries.size() == 1) {
                this.startDate = entry.getDate();
                this.start = entry.getElapsedTime();
            }
            if (entry.isStartEntry()) {
                this.setPortAndCall(entry);
            } else if (entry.isIOEnter()) {
                ++this.numberOfCalls;
            } else if (entry.isIOExit()) {
                if (entry.hasState(TransactionLogEntry.State.ERROR)) {
                    ++this.numberOfFailedCalls;
                }
            } else if (entry.isServiceExit() && this.isService() || entry.isTransitionExit() && this.isTransition()) {
                this.finished = true;
            }
            this.endDate = entry.getDate();
            this.end = entry.getElapsedTime();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isService() {
        return this.getEntry(0).isServiceEnter();
    }

    public boolean isTransition() {
        return this.getEntry(0).isTransitionEnter();
    }

    private void setPortAndCall(TransactionLogEntry entry) {
        String[] strings = PATTERN.split(entry.getComponentName());
        if (strings.length > 1) {
            this.port = strings[strings.length - 2];
            this.call = strings[strings.length - 1];
            if (this.call.startsWith("urn:")) {
                this.call = this.call.substring(4);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "RequestId: " + this.getName();
    }

    @Override
    public Object getChild(int index) {
        return this.getEntry(index);
    }

    @Override
    public int getChildCount() {
        return this.getEntries().size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.getEntries().indexOf(child);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void delete() {
    }
}

