/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.TransactionLogCall;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransactionLogLifeline {
    private String id;
    private String name;
    private final List<TransactionLogCall> calls = new ArrayList<TransactionLogCall>();
    private Map<String, List<TransactionLogCall>> backendCalls = new LinkedHashMap<String, List<TransactionLogCall>>();

    public TransactionLogLifeline(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<TransactionLogCall> getCalls() {
        return this.calls;
    }

    public synchronized void addCall(TransactionLogCall call) {
        this.calls.add(call);
        call.setLifeline(this);
    }

    public Boolean isService() {
        return this.calls.size() == 0 ? null : Boolean.valueOf(this.calls.get(0).isServiceCall());
    }

    public Boolean isBackend() {
        return this.calls.size() == 0 ? null : Boolean.valueOf(this.calls.get(0).isBackendCall());
    }

    public Boolean isPState() {
        return this.calls.size() == 0 ? null : Boolean.valueOf(this.calls.get(0).isPStateCall());
    }

    public Map<String, List<TransactionLogCall>> getBackendCalls() {
        return this.backendCalls;
    }

    public void addBackendCall(TransactionLogCall call) {
        if (call.isBackendCall()) {
            String id = call.getCall().getOperation();
            List<TransactionLogCall> bCalls = this.backendCalls.get(id);
            if (bCalls == null) {
                bCalls = new ArrayList<TransactionLogCall>();
                this.backendCalls.put(id, bCalls);
            }
            bCalls.add(call);
        }
    }
}

