/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.AnalyzerRoot;
import ch.e2e.builder.analyzer.model.Trace;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.util.Set;
import org.w3c.dom.Document;

public class TracesRoot
extends TestcaseRoot
implements AnalyzerRoot {
    private static final String FOLDER_NAME = "Traces";

    public TracesRoot() {
    }

    public TracesRoot(String name) {
        super(name);
    }

    public String getFoldername() {
        return FOLDER_NAME;
    }

    public Set<String> getExistingTraceNames() {
        return this.getChildren().keySet();
    }

    public void projectChanged(E2EBuilderProject project) {
        this.setHome(new File(project.getProjectHome(), "testcase" + File.separator + this.getFoldername()));
        this.clear();
        this.loadChildren();
    }

    private void loadChildren() {
        File[] folders;
        for (File folder : folders = FileUtilities.getAllDirectories((File)this.getHome())) {
            this.loadChild(folder);
        }
    }

    public void addTrace(String name, Document traceDocument) {
        Trace trace;
        File traceFolder = new File(this.getHome(), name);
        if (traceFolder.exists()) {
            trace = (Trace)this.get(name);
            if (trace != null) {
                try {
                    this.delete((TestcaseObject)trace);
                }
                catch (FilesNotDeletedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            traceFolder.mkdirs();
        }
        trace = new Trace(traceFolder);
        trace.setResponse(traceDocument);
        this.add((TestcaseObject)trace);
    }

    private void loadChild(File traceFolder) {
        this.add((TestcaseObject)new Trace(traceFolder));
    }
}

