/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import ch.e2e.util.StringTools;
import java.text.ParseException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class KeyValueListOption
extends Option<SortedMap<String, StringOption>> {
    private String elementName;

    public KeyValueListOption(String name, int index) {
        this(name, (SortedMap<String, StringOption>)new TreeMap<String, StringOption>(), index);
    }

    public KeyValueListOption(String name, SortedMap<String, StringOption> defaultValue, int index) {
        this(name, "map", defaultValue, index);
    }

    public KeyValueListOption(String name, String elementName, SortedMap<String, StringOption> defaultValue, int index) {
        super(name, defaultValue, index);
        this.elementName = elementName;
    }

    public void add(String key, String value) {
        this.add(key, value, false);
    }

    public void add(String key, String value, boolean inherited) {
        if (this.getValue() == null) {
            this.setValue((SortedMap<String, StringOption>)new TreeMap<String, StringOption>());
        }
        StringOption string = new StringOption(this.elementName, this.elementName, null, ((SortedMap)this.getValue()).size());
        string.setValue(value);
        string.setInherited(inherited);
        ((SortedMap)this.getValue()).put(key, string);
    }

    public boolean contains(String key) {
        return ((SortedMap)this.getValue()).containsKey(key);
    }

    @Override
    public void setValue(SortedMap<String, StringOption> value) {
        if (value != null) {
            value = new TreeMap<String, StringOption>(value);
        }
        super.setValue(value);
    }

    @Override
    public SortedMap<String, StringOption> createValue(String valueString) {
        TreeMap<String, StringOption> result = new TreeMap<String, StringOption>();
        if (valueString != null) {
            try {
                String[] strings;
                for (String s : strings = StringTools.createStringArray((String)valueString)) {
                    int splitPoint = s.indexOf(61);
                    StringOption string = new StringOption(this.elementName, this.elementName, null, result.size());
                    string.setValue(s.substring(splitPoint + 1).trim());
                    result.put(s.substring(0, splitPoint).trim(), string);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void setInherited(boolean inherited) {
        if (this.getValue() != null) {
            for (Map.Entry option : ((SortedMap)this.getValue()).entrySet()) {
                ((StringOption)option.getValue()).setInherited(inherited);
            }
        }
    }

    @Override
    public SortedMap<String, StringOption> createCopyOfValue() {
        TreeMap copiedValue = null;
        if (this.getValue() != null) {
            copiedValue = new TreeMap();
            for (Map.Entry option : ((SortedMap)this.getValue()).entrySet()) {
                StringOption copy = (StringOption)((StringOption)option.getValue()).createCopy();
                copiedValue.put(option.getKey(), copy);
            }
        }
        return copiedValue;
    }

    @Override
    public Option<SortedMap<String, StringOption>> createCopyInstance() {
        KeyValueListOption result = new KeyValueListOption(this.getName(), this.getIndex());
        result.elementName = this.elementName;
        return result;
    }

    @Override
    public void merge(Option<SortedMap<String, StringOption>> copy) {
        if (copy.getValue() != null) {
            if (this.getValue() == null) {
                this.setValue(copy.getValue());
            } else {
                for (Map.Entry<String, StringOption> option : copy.getValue().entrySet()) {
                    if (((SortedMap)this.getValue()).containsKey(option.getKey())) continue;
                    ((SortedMap)this.getValue()).put(option.getKey(), option.getValue());
                }
            }
        }
    }
}

