/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.ErrorDetail;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDiffErrorDetail
extends ErrorDetail<ArrayList<ErrorDetail<String>>> {
    public static int TYPE_XML_DIFF_ERROR_DETAIL = -5001;
    private final String file;

    public XMLDiffErrorDetail(String file, ArrayList<ErrorDetail<String>> value) {
        super(value);
        this.file = file;
    }

    public XMLDiffErrorDetail(Element detailElement) {
        super(detailElement);
        this.file = detailElement.getAttribute("file");
        this.setValue(new ArrayList());
        this.readDiffElements(detailElement.getElementsByTagName("xmlDiff"));
    }

    public String getFile() {
        return this.file;
    }

    @Override
    public Object getChild(int index) {
        return ((ArrayList)this.getValue()).get(index);
    }

    @Override
    public int getChildCount() {
        return ((ArrayList)this.getValue()).size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return ((ArrayList)this.getValue()).indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return ((ArrayList)this.getValue()).size() == 0;
    }

    @Override
    public int getType() {
        return TYPE_XML_DIFF_ERROR_DETAIL;
    }

    @Override
    public Element toXml(Document ownerDocument) {
        Element result = super.toXml(ownerDocument);
        result.setAttribute("file", this.file);
        return result;
    }

    @Override
    public String toString() {
        return "Compare of " + this.file + " contains errors.";
    }

    @Override
    public boolean hasDiffInfo() {
        return true;
    }

    @Override
    protected void appendValueElement(Element result) {
        for (ErrorDetail message : (ArrayList)this.getValue()) {
            Element value = result.getOwnerDocument().createElement("xmlDiff");
            value.appendChild(result.getOwnerDocument().createTextNode((String)message.getValue()));
            result.appendChild(value);
        }
    }

    @Override
    protected void readValue(Element detailElement) {
    }

    private void readDiffElements(NodeList diffs) {
        int length = diffs.getLength();
        for (int i = 0; i < length; ++i) {
            Node diff = diffs.item(i);
            ((ArrayList)this.getValue()).add(new ErrorDetail<String>(diff.getFirstChild().getNodeValue()));
        }
    }
}

