/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.DefaultDocumentSerializer;
import ch.e2e.test.DocumentSerializer;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestDocumentPreprocessor {
    public static final String PREPROCESSSCRIPT_DEFAULT = "DefaultSortScript";
    public static final List<String> EXISTING_SCRIPTS;
    private static TransformerLoader transformerLoader;
    private File scriptFile;
    private boolean indent;
    private String scriptName;
    private File logFolder;
    private DocumentSerializer serializer;
    private Templates scriptTemplates;
    private boolean enabled;

    public TestDocumentPreprocessor(String scriptName, boolean indent) {
        this.scriptName = scriptName;
        this.indent = indent;
    }

    public TestDocumentPreprocessor(Element preprocessorElement, String compareName, String testcaseName) {
        this.scriptName = PREPROCESSSCRIPT_DEFAULT;
        this.indent = DomUtilities.getBoolean((Element)preprocessorElement, (String)"indent", (boolean)true);
        this.enabled = DomUtilities.getBoolean((Element)preprocessorElement, (String)"enabled", (boolean)false);
        NodeList children = preprocessorElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equalsIgnoreCase("scriptFile")) {
                this.scriptFile = new File(DomUtilities.getTextValue((Element)((Element)child), null));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("scriptName")) {
                this.scriptName = DomUtilities.getTextValue((Element)((Element)child), null);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("logFolder")) continue;
            String logFolder = DomUtilities.getTextValue((Element)((Element)child), null);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("name", compareName);
            properties.put("testcase", testcaseName);
            this.logFolder = new File(StringTools.replaceProperties((String)logFolder, properties));
        }
    }

    public void savePreprocessedDocument(Document document, String filename) throws IOException, TransformerException {
        if (this.logFolder != null) {
            if (!this.logFolder.exists()) {
                this.logFolder.mkdirs();
            }
            File logFile = new File(this.logFolder, filename + ".preprocess");
            if (this.serializer == null) {
                DefaultDocumentSerializer.getInstance().serialize(document, logFile, this.indent);
            } else {
                this.serializer.serialize(document, logFile, this.indent);
            }
        }
    }

    public File getPreprocessedFile(String filename) {
        File result = null;
        if (this.logFolder != null && this.logFolder.exists()) {
            result = new File(this.logFolder, filename + ".preprocess");
        }
        return result;
    }

    public Document preprocess(Document document) throws TransformerLoadException, TransformerException {
        if (this.scriptTemplates == null) {
            this.scriptTemplates = this.scriptFile == null ? transformerLoader.getTemplates(this.scriptName) : transformerLoader.getTemplates(this.scriptFile);
        }
        Document result = null;
        if (this.scriptTemplates != null) {
            Transformer transformer = this.scriptTemplates.newTransformer();
            DOMSource domSource = new DOMSource(document);
            DOMResult domResult = new DOMResult();
            transformer.transform(domSource, domResult);
            result = (Document)domResult.getNode();
        }
        return result;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
    }

    public void setSerializer(DocumentSerializer serializer) {
        this.serializer = serializer;
    }

    public void toXml(Element parent) {
        if (this.enabled || this.scriptFile != null || !this.scriptName.equals(PREPROCESSSCRIPT_DEFAULT)) {
            Element result = parent.getOwnerDocument().createElement("preprocessor");
            result.setAttribute("enabled", String.valueOf(this.enabled));
            result.setAttribute("indent", String.valueOf(this.indent));
            if (this.scriptFile != null) {
                Element scriptFile = parent.getOwnerDocument().createElement("scriptFile");
                scriptFile.appendChild(parent.getOwnerDocument().createTextNode(this.toString()));
                result.appendChild(scriptFile);
            }
            if (!this.scriptName.equals(PREPROCESSSCRIPT_DEFAULT)) {
                Element scriptName = parent.getOwnerDocument().createElement("scriptName");
                scriptName.appendChild(parent.getOwnerDocument().createTextNode(this.scriptName));
                result.appendChild(scriptName);
            }
            if (this.logFolder != null) {
                Element logfolder = parent.getOwnerDocument().createElement("logFolder");
                logfolder.appendChild(parent.getOwnerDocument().createTextNode(this.logFolder.getPath()));
                result.appendChild(logfolder);
            }
            parent.appendChild(result);
        }
    }

    public String toString() {
        return this.scriptFile == null ? "" : this.scriptFile.toString();
    }

    static {
        Properties properties = new Properties("ch.e2e.test.preprocessorscripts");
        transformerLoader = new TransformerLoader((String)null, properties);
        EXISTING_SCRIPTS = new ArrayList<String>();
        for (Object o : properties.keySet()) {
            EXISTING_SCRIPTS.add(o.toString());
        }
    }
}

