/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.swing.TreeObject;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.TestFailedError;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorElement
implements TreeObject {
    private static final String XML_class = "class";
    private static final String XML_Message = "Message";
    private static final String XML_Details = "Details";
    private static final String XML_Error = "Error";
    private String classname;
    private String message;
    private List<ErrorDetail> errorDetails;
    private E2ETest owner;

    public ErrorElement(Throwable error) {
        if (error != null) {
            this.classname = error.getClass().getName();
            this.errorDetails = this.classname.equals(TestFailedError.class.getName()) ? ((TestFailedError)((Object)error)).getErrorDetails() : new ArrayList<ErrorDetail>();
        }
        this.generateMessage(error);
    }

    private void generateMessage(Throwable error) {
        if (error == null) {
            this.message = "null";
        } else {
            this.message = this.generateName(error.getClass().getSimpleName());
            if (error.getMessage() != null && error.getMessage().length() != 0) {
                this.message = this.message + " - " + error.getMessage();
            }
        }
    }

    private String generateName(String str) {
        int index = (str = this.splitCamelCase(str)).indexOf("Exception");
        if (index <= 0) {
            return str;
        }
        return str.substring(0, index - 1);
    }

    private String splitCamelCase(String str) {
        return str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public ErrorElement(Element errorElement) {
        this.classname = errorElement.getAttribute(XML_class);
        NodeList messages = errorElement.getElementsByTagName(XML_Message);
        if (messages != null && messages.getLength() > 0) {
            this.message = messages.item(0).getFirstChild().getNodeValue();
        }
        this.errorDetails = new ArrayList<ErrorDetail>();
        NodeList details = errorElement.getElementsByTagName(XML_Details);
        if (details != null && details.getLength() == 1) {
            this.readDetails((Element)details.item(0));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E2ETest getOwner() {
        return this.owner;
    }

    public void setOwner(E2ETest owner) {
        this.owner = owner;
    }

    public String getClassname() {
        return this.classname;
    }

    public void clear() {
        this.classname = null;
        this.errorDetails.clear();
        this.errorDetails = null;
        this.message = null;
    }

    public void appendTo(Element parent) {
        Element errorElement = parent.getOwnerDocument().createElement(XML_Error);
        errorElement.setAttribute(XML_class, this.classname);
        Element messageElement = parent.getOwnerDocument().createElement(XML_Message);
        messageElement.appendChild(parent.getOwnerDocument().createTextNode(this.message));
        errorElement.appendChild(messageElement);
        Element detailsElement = parent.getOwnerDocument().createElement(XML_Details);
        for (ErrorDetail errorDetail : this.errorDetails) {
            detailsElement.appendChild(errorDetail.toXml(parent.getOwnerDocument()));
        }
        errorElement.appendChild(detailsElement);
        parent.appendChild(errorElement);
    }

    public String toString() {
        return this.message;
    }

    public Object getChild(int index) {
        return this.errorDetails.get(index);
    }

    public int getChildCount() {
        return this.errorDetails.size();
    }

    public int getIndexOfChild(Object child) {
        return this.errorDetails.indexOf(child);
    }

    public boolean isLeaf() {
        return this.errorDetails.size() == 0;
    }

    public int getType() {
        return 0;
    }

    public boolean hasDiffInfo() {
        boolean result = false;
        int length = this.errorDetails.size();
        for (int i = 0; !result && i < length; ++i) {
            result = this.errorDetails.get(i).hasDiffInfo();
        }
        return result;
    }

    public List<ErrorDetail> getErrorDetails() {
        return this.errorDetails;
    }

    public ErrorDetail getFirstDiffErrorDetail() {
        ErrorDetail result = null;
        int length = this.errorDetails.size();
        for (int i = 0; result == null && i < length; ++i) {
            ErrorDetail errorDetail = this.errorDetails.get(i);
            result = errorDetail.hasDiffInfo() ? errorDetail : null;
        }
        return result;
    }

    private void readDetails(Element detailsElement) {
        NodeList details = detailsElement.getElementsByTagName("Detail");
        int length = details.getLength();
        for (int i = 0; i < length; ++i) {
            Element detail = (Element)details.item(i);
            String classname = detail.getAttribute("type");
            try {
                Class<?> clazz = Class.forName(classname);
                Constructor<?> constructor = clazz.getConstructor(Element.class);
                this.errorDetails.add((ErrorDetail)constructor.newInstance(detail));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

