/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETestSuiteTemplate;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public enum E2ETestSuiteTemplateFactory {
    INSTANCE;

    private Map<String, E2ETestSuiteTemplate> testSuiteFiles = new HashMap<String, E2ETestSuiteTemplate>();

    public static E2ETestSuiteTemplateFactory getInstance() {
        return INSTANCE;
    }

    public E2ETestSuiteTemplate getTemplate(File file, boolean inLibrary) throws Exception {
        String absolutePath = FileUtilities.getAbsolutePath((File)file);
        E2ETestSuiteTemplate template = this.testSuiteFiles.get(absolutePath);
        if (template == null) {
            template = new E2ETestSuiteTemplate(file, inLibrary);
            this.testSuiteFiles.put(absolutePath, template);
        }
        return template;
    }

    public void removeTemplate(File file) {
        E2ETestSuiteTemplate template = this.testSuiteFiles.remove(FileUtilities.getAbsolutePath((File)file));
        if (template != null) {
            template.clean();
        }
    }

    public void clear() {
        for (E2ETestSuiteTemplate template : this.testSuiteFiles.values()) {
            template.clean();
        }
        this.testSuiteFiles.clear();
    }
}

