/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestcaseTemplate;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestCreator;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class E2ETestSuiteTemplate
extends E2ETestSuite
implements TestCreator {
    private File file;
    private long lastModified;

    public E2ETestSuiteTemplate(File file, boolean inLibrary) throws Exception {
        this.file = file;
        this.lastModified = -1L;
        this.setInLibrary(inLibrary);
        this.loadTemplate();
    }

    @Override
    public File getTestSuiteFile() {
        return this.file;
    }

    @Override
    public void setParent(E2ETestSuite parent) {
        if (!this.isLibrary()) {
            super.setParent(parent);
        }
    }

    @Override
    public void setTestSuiteFile(File file) {
        if (this.file != null && this.getParent() instanceof E2ETestSuite) {
            String oldId = this.file.getParentFile().getName();
            String newId = file.getParentFile().getName();
            if (!newId.equals(oldId)) {
                ((E2ETestSuite)this.getParent()).changeId(newId, oldId);
            }
        }
        this.file = file;
    }

    @Override
    public Testable createTestcase(Element testcaseElement, File parentFile) throws Exception {
        return new E2ETestcaseTemplate(testcaseElement, parentFile);
    }

    @Override
    public void reload() throws Exception {
        this.loadTemplate();
    }

    private void loadTemplate() throws Exception {
        if (this.file.exists() && this.file.lastModified() > this.lastModified) {
            this.lastModified = this.file.lastModified();
            Document document = DomUtilities.parse((File)this.file, (boolean)false, (boolean)false);
            this.loadTestSuiteDocument(document, this.file);
        }
    }

    @Override
    public Map<TestType, OptionContainer> getOptions() {
        return super.getOptions();
    }
}

