/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.importer;

import ch.e2e.builder.trace.importer.WSDLImport;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import java.io.File;
import java.io.FileFilter;
import org.w3c.dom.Document;

public class WSDLImportTest
extends E2ETest {
    public static final String KEY = "WSDLImportTest";
    public static final String KEY_OPTION_WSDL_FOLDER = "wsdl.folder";
    public static final String KEY_OPTION_TESTCASES_DOCUMENT = "testcases.document.file";

    public void doTest() throws Exception {
        FileOption wsdlFolder = (FileOption)this.getOption(KEY_OPTION_WSDL_FOLDER);
        WSDLImportTest.assertFalse((String)"The option wsdl.folder must be defined", (wsdlFolder.getValue() == null ? 1 : 0) != 0);
        FileOption testcasesDocument = (FileOption)this.getOption(KEY_OPTION_TESTCASES_DOCUMENT);
        WSDLImportTest.assertFalse((String)"The option testcases.document.file must be defined", (testcasesDocument.getValue() == null ? 1 : 0) != 0);
        File[] wsdlFiles = FileUtilities.getFileList((File)((File)wsdlFolder.getValue()), (FileFilter)new WSDLImport.WSDLFileFilter());
        Document testcases = new WSDLImport.FileImportSource(wsdlFiles).createTestcasesDocument();
        DomUtilities.serialize((File)((File)testcasesDocument.getValue()), (Document)testcases, (boolean)true);
    }

    public String getRecommendedCompareType() {
        return "XMLCompare";
    }

    public void testImport() throws Exception {
        System.setProperty("ch.e2e.builder.trace.xmlpath", "D:\\Projects\\e2e_bridge\\builder\\head\\xslt\\trace\\xml\\src");
        this.getOption(KEY_OPTION_WSDL_FOLDER).setValue((Object)new File("sources/Example"));
        this.getOption(KEY_OPTION_TESTCASES_DOCUMENT).setValue((Object)new File("output/Example/all.wsdl"));
        this.doTest();
        XMLCompare compare = new XMLCompare();
        ((Option)compare.getOptions().get("xml.compare.test.file")).setValue((Object)new CompareFile(new File("output/Example/all.wsdl")));
        ((Option)compare.getOptions().get("xml.compare.reference.file")).setValue((Object)new CompareFile(new File("reference/Example/all.wsdl")));
        compare.doTest((E2ETest)this);
    }

    protected void createOptions() {
        FileOption testcases = new FileOption("Testcases Document", KEY_OPTION_TESTCASES_DOCUMENT, 1);
        testcases.setRequired(true);
        this.addOption(KEY_OPTION_TESTCASES_DOCUMENT, (Option)testcases);
        FileOption wsdlFolder = new FileOption("WSDL Folder", KEY_OPTION_WSDL_FOLDER, 0);
        wsdlFolder.setRequired(true);
        this.addOption(KEY_OPTION_WSDL_FOLDER, (Option)wsdlFolder);
    }
}

