/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.FileInputField;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectAction;
import ch.e2e.builder.base.project.ProjectEntry;
import ch.e2e.builder.base.project.ProjectSetting;
import ch.e2e.builder.base.project.event.ProjectFolderChangedEvent;
import ch.e2e.builder.base.project.event.ProjectFolderChangedListener;
import ch.e2e.builder.base.project.gui.ActionButton;
import ch.e2e.builder.base.project.gui.ObjectInputField;
import ch.e2e.builder.base.project.gui.ProjectWizardPanel;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.swing.InputComboBox;
import ch.e2e.swing.InputDoubleField;
import ch.e2e.swing.InputIntegerField;
import ch.e2e.swing.InputRadioButton;
import ch.e2e.swing.InputTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ModulePanel
extends ProjectWizardPanel
implements ProjectFolderChangedListener,
InputFieldListener {
    private HashMap<String, Input> fields = new HashMap();
    private String moduleName;
    private String modulePrefix;
    private HashMap<String, ButtonGroup> buttonGroups = new HashMap();
    private ArrayList<InputField> requiredFields = new ArrayList();
    private InputFieldListener inputListener;
    private ArrayList<ActionButton> actionButtons;

    public ModulePanel(String moduleName, String modulePrefix, ProjectSetting[] projectEntries) {
        this.moduleName = moduleName;
        this.modulePrefix = modulePrefix;
        this.createGui(projectEntries);
    }

    public void addInputFieldListener(InputFieldListener inputListener) {
        this.inputListener = InputFieldEventMulticaster.addListener((InputFieldListener)inputListener, (InputFieldListener)this.inputListener);
    }

    public void removeInputFieldListener(InputFieldListener inputListener) {
        this.inputListener = InputFieldEventMulticaster.removeListener((InputFieldListener)inputListener, (InputFieldListener)this.inputListener);
    }

    public boolean isComplete() {
        boolean result = true;
        int length = this.requiredFields.size();
        for (int i = 0; i < length && result; ++i) {
            InputField inputField = this.requiredFields.get(i);
            result = inputField instanceof JTextComponent ? ((JTextComponent)inputField).getText().length() > 0 : (inputField instanceof InputCheckBox ? ((InputCheckBox)inputField).isSelected() : inputField.getContent() != null);
        }
        return result;
    }

    public void inputFieldChanged(InputFieldEvent e) {
        this.inputListener.inputFieldChanged(e);
    }

    @Override
    void fillProjectInfo(E2EBuilderProject project) {
        for (String key : this.fields.keySet()) {
            Input input = this.fields.get(key);
            input.inputField.setContent(project.get(this.moduleName, key, input.defaultValue));
        }
    }

    public void fillDefaults(File projectHome) {
        for (String key : this.fields.keySet()) {
            Object defaultValue;
            Input input = this.fields.get(key);
            if (input.inputField instanceof FileInputField) {
                File defaultFile = (File)input.defaultValue;
                if (!defaultFile.isAbsolute()) {
                    defaultFile = new File(projectHome, defaultFile.getPath());
                }
                defaultValue = defaultFile;
            } else {
                defaultValue = input.defaultValue;
            }
            input.inputField.setContent(defaultValue);
        }
    }

    public void fillProject(E2EBuilderProject project) throws PropertyVetoException {
        for (String key : this.fields.keySet()) {
            Input input = this.fields.get(key);
            project.set(this.moduleName, key, input.inputField.getContent());
        }
    }

    @Override
    public void projectFolderChanged(ProjectFolderChangedEvent event) {
        for (String key : this.fields.keySet()) {
            Input input = this.fields.get(key);
            if (!(input.inputField instanceof FileInputField)) continue;
            this.checkFolderField((FileInputField)input.inputField, event.getNewPath(), event.getOldPath());
        }
    }

    public ArrayList<ActionButton> getActionButtons() {
        return this.actionButtons;
    }

    public HashMap<String, Object> getActualValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.fields.keySet()) {
            Input input = this.fields.get(key);
            result.put(key, input.inputField.getContent());
        }
        return result;
    }

    private void checkFolderField(FileInputField inputField, File newHome, File oldHome) {
        String oldHomeStr = oldHome.getAbsolutePath();
        if (inputField.getText().startsWith(oldHomeStr)) {
            File oldFile = new File(inputField.getText());
            String relativePath = FileUtilities.getRelativePath((File)oldFile, (File)oldHome);
            File newFile = new File(newHome, relativePath);
            inputField.setText(newFile.getAbsolutePath());
        }
    }

    private void createGui(ProjectSetting[] projectSettings) {
        this.actionButtons = new ArrayList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = this.createGridBagConstraints();
        for (ProjectSetting setting : projectSettings) {
            ProjectEntry[] entries = setting.getProjectEntries();
            for (int i = 0; i < entries.length; ++i) {
                if (!entries[i].isVisible()) continue;
                c.fill = entries[i].getFill();
                c.weightx = entries[i].getWeightx();
                if (entries[i] instanceof ProjectAction) {
                    this.addButton((ProjectAction)entries[i], c);
                    continue;
                }
                boolean last = i == projectSettings.length - 1;
                this.addInputField(entries[i], last, c);
            }
        }
    }

    private void addButton(ProjectAction action, GridBagConstraints c) {
        JButton button = ComponentFactory.createButton(action.getName(), this.moduleName);
        c.gridwidth = action.isFieldRemainder() ? 0 : 1;
        c.anchor = action.getAnchor();
        this.add((Component)button, c);
        this.actionButtons.add(new ActionButton(action, button));
    }

    private void addInputField(ProjectEntry projectEntry, boolean last, GridBagConstraints c) {
        InputField field = this.addInputField(this, c, this.moduleName, projectEntry, last);
        this.fields.put(projectEntry.getName(), new Input(field, (ProjectSetting)projectEntry));
        if (projectEntry.isRequired()) {
            this.requiredFields.add(field);
            field.addInputFieldListener((InputFieldListener)this);
        }
    }

    private GridBagConstraints createGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 0, 5);
        c.anchor = 18;
        return c;
    }

    private InputField addInputField(JPanel panel, GridBagConstraints c, String module, ProjectEntry entry, boolean last) {
        Object field;
        Object defaultValue = entry.getDefaultValue();
        int n = c.gridwidth = entry.isNameRemainder() ? 0 : 1;
        if (entry.getValue() instanceof Vector) {
            field = new InputComboBox((Vector)entry.getValue());
            this.addInputField(panel, (InputField)field, (GridBagConstraints)c.clone(), entry, module, last);
        } else if (defaultValue instanceof File) {
            FileInputField fileInput = this.addFileInputField(panel, c, entry.getName(), module, last);
            fileInput.setHorizontalAlignment(entry.getHorizontalAlignment());
            field = fileInput;
        } else if (defaultValue instanceof Integer) {
            field = new InputIntegerField(Integer.MIN_VALUE, Integer.MAX_VALUE);
            ((InputIntegerField)field).setHorizontalAlignment(entry.getHorizontalAlignment());
            this.addInputField(panel, (InputField)field, c, entry, module, last);
        } else if (defaultValue instanceof Double) {
            field = new InputDoubleField(Double.MIN_VALUE, Double.MAX_VALUE);
            ((InputDoubleField)field).setHorizontalAlignment(entry.getHorizontalAlignment());
            this.addInputField(panel, (InputField)field, c, entry, module, last);
        } else if (defaultValue instanceof Boolean) {
            field = this.createBooleanEntry(panel, c, module, entry, last);
        } else if (defaultValue instanceof String) {
            field = new InputTextField();
            ((InputTextField)field).setHorizontalAlignment(entry.getHorizontalAlignment());
            this.addInputField(panel, (InputField)field, c, entry, module, last);
        } else {
            field = new ObjectInputField(entry.getDefaultValue().getClass());
            ((ObjectInputField)((Object)field)).setHorizontalAlignment(entry.getHorizontalAlignment());
            this.addInputField(panel, (InputField)field, c, entry, module, last);
        }
        field.setEditable(entry.isEditable());
        return field;
    }

    private InputField createBooleanEntry(JPanel panel, GridBagConstraints c, String module, ProjectEntry entry, boolean last) {
        InputCheckBox field;
        String label = this.getModuleTranslation(module, entry.getName() + ".label");
        String group = entry.getGroup();
        if (group != null) {
            ButtonGroup bg = this.buttonGroups.get(group);
            if (bg == null) {
                bg = new ButtonGroup();
                this.buttonGroups.put(group, bg);
            }
            field = new InputRadioButton(label, ((Boolean)entry.getDefaultValue()).booleanValue());
            bg.add((AbstractButton)((InputRadioButton)field));
        } else {
            field = new InputCheckBox(label);
        }
        if (last) {
            c.weighty = 1.0;
        }
        panel.add((Component)((JComponent)field), c);
        return field;
    }

    private FileInputField addFileInputField(JPanel panel, GridBagConstraints c, String entryName, String module, boolean last) {
        JLabel label = ComponentFactory.createLabel(entryName + ".label", module);
        String title = this.getModuleTranslation(module, entryName + ".chooser.title");
        String subtitle = this.getModuleTranslation(module, entryName + ".chooser.subtitle");
        return this.createFolderInput(label, title, subtitle, panel, c, last);
    }

    private void addInputField(JPanel panel, InputField field, GridBagConstraints c, ProjectEntry entry, String module, boolean last) {
        String key = entry.getName() + ".label";
        String label = E2EBuilderTranslator.getModuleTranslation((String)module, (String)key, (String)key);
        c.gridwidth = entry.isNameRemainder() ? 0 : 1;
        panel.add((Component)new JLabel(label), c);
        if (last) {
            c.weighty = 1.0;
        }
        int n = c.gridwidth = entry.isFieldRemainder() ? 0 : 1;
        if (field instanceof JTextField && c.fill == 0 && c.gridwidth == 0) {
            JPanel helpPanel = new JPanel(new GridBagLayout());
            helpPanel.add((Component)((JTextField)field), c);
            GridBagConstraints help = new GridBagConstraints();
            help.insets = new Insets(0, 0, 0, 0);
            help.fill = 2;
            help.anchor = c.anchor;
            help.gridwidth = 0;
            help.weightx = 1.0;
            this.add((Component)helpPanel, help);
        } else {
            panel.add((Component)((JComponent)field), c);
        }
    }

    private class Input {
        private ProjectSetting projectSetting;
        private InputField inputField;
        private Object defaultValue;

        private Input(InputField inputField, ProjectSetting projectSetting) {
            this.inputField = inputField;
            this.projectSetting = projectSetting;
            this.defaultValue = projectSetting.getProjectEntries()[0].getDefaultValue();
        }
    }
}

