/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.TransactionParticipant;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.event.ToggleMenuEvent;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.io.E2EBuilderFileChooser;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.EditProjectExecuter;
import ch.e2e.builder.base.project.LoadProjectExecuter;
import ch.e2e.builder.base.project.Logging;
import ch.e2e.builder.base.project.NewProjectExecuter;
import ch.e2e.builder.base.project.OpenLastProjectExecuter;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectFile;
import ch.e2e.builder.base.project.ProjectInstantiationException;
import ch.e2e.builder.base.project.ProjectSerializer;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.project.event.ClearRecentProjectsEvent;
import ch.e2e.builder.base.project.event.OpenRecentProjectEvent;
import ch.e2e.builder.base.project.event.ProjectEditEvent;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectEventMulticaster;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.project.event.ProjectNewEvent;
import ch.e2e.builder.base.project.event.ProjectOpenEvent;
import ch.e2e.builder.base.project.event.RecentProjectsEvent;
import ch.e2e.builder.base.project.gui.ProjectFileSystemView;
import ch.e2e.builder.base.project.gui.ProjectFileView;
import ch.e2e.builder.base.resource.DialogStrings;
import ch.e2e.builder.base.resource.E2EBuilderProperties;
import ch.e2e.builder.base.resource.E2EBuilderStrings;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FileUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class ProjectPool
implements ProjectConstants,
VetoableChangeListener,
DialogStrings,
E2EBuilderStrings,
EventExecuter,
Logging {
    public static File defaultProjectHome;
    LoadProjectExecuter loadExecuter;
    private int recentProjectsCount = 10;
    private E2EBuilderProperties applicationProperties;
    private E2EBuilderProject actualProject;
    private ArrayList<String> recentProjects;
    private ProjectListener listener;
    private LoadProjectTransaction loadProjectTransaction = new LoadProjectTransaction();
    private File projectHome;
    private ProjectFileFilter fileFilter;

    public ProjectPool(E2EBuilderProperties applicationProperties, ModuleFactory moduleFactory) {
        this.applicationProperties = applicationProperties;
        this.setProjectHome();
        this.setRecentProjects();
        this.addEventHandler(moduleFactory);
        this.fileFilter = new ProjectFileFilter();
    }

    public void addProjectListener(ProjectListener listener) {
        this.listener = ProjectEventMulticaster.addListener(this.listener, listener);
    }

    public void removeProjectListener(ProjectListener listener) {
        this.listener = ProjectEventMulticaster.removeListener(this.listener, listener);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getPropertyName().equals("home")) {
            this.renameProject(event);
        }
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        this.recentProjects.clear();
        this.saveRecentProjects();
        EventController.fire((EventObject)new RecentProjectsEvent(this, this.recentProjects));
    }

    public File getProjectHome() {
        return this.projectHome;
    }

    public void relaodProject() {
        if (this.actualProject != null) {
            this.setActualProject(this.actualProject);
        }
    }

    private void renameProject(PropertyChangeEvent event) throws PropertyVetoException {
        File projectFolder = (File)event.getNewValue();
        if (FileUtilities.containsFiles((File)projectFolder) && !this.checkOverwriteFolder()) {
            throw new PropertyVetoException("", event);
        }
        boolean renamed = ((File)event.getOldValue()).renameTo((File)event.getNewValue());
        if (!renamed) {
            this.moveAll((File)event.getOldValue(), (File)event.getNewValue());
        }
        E2EBuilder.getInstance().getProperties().setProperty("lastproject", new File(E2EBuilderProject.getProjectFolderName()));
    }

    private void moveAll(File from, File to) {
        File[] allFiles;
        for (File allFile : allFiles = FileUtilities.getAllFiles((File)from, (boolean)true)) {
            if (allFile.isHidden()) continue;
            File newFile = new File(to, FileUtilities.getRelativePath((File)allFile, (File)from));
            try {
                FileUtilities.copyFile((File)allFile, (File)newFile, (boolean)true);
                allFile.delete();
            }
            catch (IOException ioEx) {
                String classname = this.getClass().getName();
                E2EBuilder.logger.severe("Caught a " + ioEx.getClass().getName() + " in " + classname + ".moveAll");
                E2EBuilder.logger.throwing(classname, "moveAll", ioEx);
            }
        }
        allFiles = FileUtilities.getAllFiles((File)from, (boolean)true);
        if (allFiles.length == 0) {
            try {
                FileUtilities.deleteDirectory((File)from);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "moveAll", e);
            }
        }
    }

    public void fireDoBeforeChanging() throws EventExecutionVetoException {
        if (this.listener != null) {
            this.listener.doBeforeChanging(new ProjectEvent((Object)this, this.actualProject));
        }
    }

    public void fireProjectOpenEvents() {
        this.fireDoAfterProjectOpen();
        this.fireProjectOpened();
    }

    private void fireProjectOpened() {
        if (this.listener != null) {
            this.listener.projectOpened(new ProjectEvent((Object)this, this.actualProject));
        }
        this.updateRecentProjects();
        System.setProperty("ch.e2e.builder.development.dir", new File(E2EBuilderProject.getProjectFolderName(), Utilities.WORK_FOLDER).getAbsolutePath());
        System.gc();
    }

    private void updateRecentProjects() {
        String path = E2EBuilderProject.getProjectFolderName();
        if (this.recentProjects.contains(path)) {
            this.recentProjects.remove(path);
        }
        if (this.recentProjects.size() == this.recentProjectsCount) {
            this.recentProjects.remove(this.recentProjectsCount - 1);
        }
        ArrayList<String> recentProjects = new ArrayList<String>(this.recentProjects);
        this.recentProjects.add(0, path);
        this.saveRecentProjects();
        EventController.fire((EventObject)new RecentProjectsEvent(this, recentProjects));
    }

    public E2EBuilderProject getActualProject() {
        return this.actualProject;
    }

    void setActualProject(E2EBuilderProject actualProject) {
        this.setActualProject(actualProject, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    void setActualProject(final E2EBuilderProject actualProject, final ActionListener finishedAction) {
        this.projectHome = new File(E2EBuilderProject.getProjectFolderName());
        this.fireDoBeforeProjectOpen(actualProject);
        this.loadProjectTransaction.setProjectToLoad(actualProject);
        EventController.fire((EventObject)new DoTransactionEvent(this, this.loadProjectTransaction, actualProject, new TransactionParticipant(){

            @Override
            public void transactionStarts() {
            }

            @Override
            public void transactionStarted() {
            }

            @Override
            public void transactionFinished() {
                finishedAction.actionPerformed(new ActionEvent(this, 1001, actualProject.getName()));
                ProjectPool.this.fireProjectOpened();
            }

            @Override
            public boolean isRemoveAfterAction() {
                return true;
            }
        }));
    }

    public void settingsChanged() {
        this.fireProjectSettingsChange(new ProjectEvent((Object)this, this.actualProject));
        this.saveProject();
        System.gc();
    }

    public void saveProject() {
        if (this.actualProject != null && !this.actualProject.isNew()) {
            ProjectSerializer.serialize(this.actualProject);
        }
    }

    public File selectProjectFile() {
        E2EBuilderFileChooser fileChooser = this.getFileChooser();
        fileChooser.setFileFilter(new E2EFileFilter[]{this.fileFilter}, this.fileFilter);
        return fileChooser.selectFile(this.getProjectHome().getParentFile(), new ProjectFile(this.getProjectHome()), false);
    }

    private E2EBuilderFileChooser getFileChooser() {
        ProjectFileSystemView fileSystemView = new ProjectFileSystemView();
        E2EBuilderFileChooser fileChooser = E2EBuilderFileChooser.createFileChooser(FileSystemView.getFileSystemView().getHomeDirectory(), fileSystemView, E2EBuilderTranslator.getTranslation((String)"project.chooser.title"), E2EBuilderTranslator.getTranslation((String)"project.chooser.internaltitle"), E2EBuilderTranslator.getTranslation((String)"project.chooser.subtitle"));
        fileChooser.setFileView((FileView)((Object)new ProjectFileView(fileSystemView)));
        fileChooser.setOkButtonEnabled(false);
        return fileChooser;
    }

    private boolean checkOverwriteFolder() {
        return ProjectPool.checkOverwriteFolder("project.folder.overwrite.rename.question");
    }

    public static boolean checkOverwriteFolder(String questionKey) {
        String title = E2EBuilderTranslator.getTranslation((String)"project.folder.overwrite.title", (String)"project.folder.overwrite.title");
        String subtitle = E2EBuilderTranslator.getTranslation((String)"project.folder.overwrite.subtitle", (String)"project.folder.overwrite.subtitle");
        String question = E2EBuilderTranslator.getTranslation((String)questionKey, (String)questionKey);
        return E2EBuilderQuestionDialog.doYesNoQuestion(title, subtitle, question);
    }

    private void fireProjectSettingsChange(ProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectSettingsChange(event);
        }
    }

    private void fireDoBeforeProjectOpen(E2EBuilderProject project) {
        if (this.listener != null) {
            this.listener.doBeforeProjectOpen(new ProjectEvent((Object)this, project));
        }
    }

    private void fireDoAfterProjectOpen() {
        if (this.listener != null) {
            this.listener.doAfterProjectOpen(new ProjectEvent((Object)this, this.actualProject));
        }
    }

    private void addEventHandler(ModuleFactory moduleFactory) {
        this.loadExecuter = new LoadProjectExecuter(this);
        EventController.register((EventExecuter)this.loadExecuter, ProjectOpenEvent.class);
        EventController.register((EventExecuter)new EditProjectExecuter(this, moduleFactory), ProjectEditEvent.class);
        EventController.register((EventExecuter)new NewProjectExecuter(this, moduleFactory), ProjectNewEvent.class);
        EventController.register((EventExecuter)this, ClearRecentProjectsEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ProjectPool.this.openRecentProject((OpenRecentProjectEvent)((Object)event));
            }
        }, OpenRecentProjectEvent.class);
        EventController.register((EventExecuter)new OpenLastProjectExecuter(this), ToggleMenuEvent.class);
    }

    private void openRecentProject(OpenRecentProjectEvent event) {
        File home = new File(event.getPath());
        if (home.exists()) {
            this.setActualProject(home);
        } else {
            E2EBuilderInfoDialog.error("The project '" + home.getAbsolutePath() + "' does not exist anymore.");
        }
    }

    public void setActualProject(File projectHome) {
        try {
            HashMap<String, ProjectSettingObjectWSChecker> checkers = E2EBuilder.getInstance().getCheckers();
            E2EBuilderProject actualProject = new E2EBuilderProject(projectHome, checkers);
            this.setActualProject(actualProject);
        }
        catch (ProjectInstantiationException piEx) {
            if (piEx.getTargetException() == null) {
                piEx.printStackTrace();
            } else {
                piEx.getTargetException().printStackTrace();
            }
            E2EBuilderInfoDialog.error("Could not load xUML project '" + projectHome + "'.");
        }
    }

    private void setProjectHome() {
        try {
            String lastProject = this.applicationProperties.getString("lastproject");
            this.projectHome = new File(lastProject);
            if (this.projectHome.isFile()) {
                this.projectHome = this.projectHome.getParentFile();
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (this.projectHome == null || !this.projectHome.exists()) {
            this.projectHome = defaultProjectHome;
        }
    }

    public void setInitialProject() {
        if (this.applicationProperties.getBoolean("openproject")) {
            File projectHome;
            String lastProject = null;
            try {
                lastProject = this.applicationProperties.getString("lastproject");
                if (lastProject.length() == 0) {
                    lastProject = null;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (lastProject == null) {
                projectHome = defaultProjectHome;
            } else {
                projectHome = new File(lastProject);
                if (projectHome.isFile()) {
                    projectHome = projectHome.getParentFile();
                }
            }
            EventController.fire((EventObject)new RecentProjectsEvent(this, this.recentProjects));
            this.setActualProject(projectHome);
        } else {
            EventController.fire((EventObject)new RecentProjectsEvent(this, this.recentProjects));
        }
    }

    private void setRecentProjects() {
        try {
            String[] recentProjects = this.applicationProperties.getStringArray("recentprojects");
            this.recentProjects = new ArrayList<String>(Arrays.asList(recentProjects));
        }
        catch (MissingResourceException mrEx) {
            this.recentProjects = new ArrayList();
        }
        EventController.fire((EventObject)new RecentProjectsEvent(this, this.recentProjects));
    }

    private void saveRecentProjects() {
        String[] recentProjects = new String[this.recentProjects.size()];
        this.recentProjects.toArray(recentProjects);
        this.applicationProperties.setProperty("recentprojects", recentProjects);
        this.applicationProperties.saveProperties();
    }

    public boolean getOpenLastProject() {
        String property = this.applicationProperties.getProperty("openproject");
        if (property == null) {
            this.applicationProperties.setProperty("openproject", true);
            property = this.applicationProperties.getProperty("openproject");
        }
        return Boolean.valueOf(property);
    }

    public void setOpenLastProject(boolean open) {
        this.applicationProperties.setProperty("openproject", open);
        this.applicationProperties.saveProperties();
    }

    static {
        File current = new File("").getAbsoluteFile();
        File root = FileUtilities.getRoot((File)current);
        File parent = new File(root, "E2EBuilder Projects");
        defaultProjectHome = new File(parent, "NewProject");
    }

    public class ProjectFileFilter
    extends E2EFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return ProjectFileSystemView.isProjectFolder(file.getParentFile()) || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Scheer PAS Builder Project";
        }

        @Override
        public String getDefaultExtension() {
            return "e2ebuilder";
        }
    }

    private class LoadProjectTransaction
    extends E2EBuilderTransaction {
        private String description;

        private LoadProjectTransaction() {
        }

        @Override
        public Object doTransaction(Object transactionData) throws Throwable {
            if (ProjectPool.this.actualProject != null) {
                ProjectPool.this.actualProject.removePropertyChangeListener();
                ProjectPool.this.saveProject();
            }
            ProjectPool.this.actualProject = (E2EBuilderProject)transactionData;
            E2EBuilder.getInstance().getProperties().setProperty("lastproject", E2EBuilderProject.getProjectFolderName());
            E2EBuilder.getInstance().getProperties().saveProperties();
            ProjectPool.this.actualProject.setPropertyChangeListener((VetoableChangeListener)ProjectPool.this);
            ProjectPool.this.fireDoAfterProjectOpen();
            return transactionData;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void prepareTransaction() {
        }

        @Override
        public void setTransactionResult(Object transactionResult) {
        }

        @Override
        public boolean doErrorHandling(Throwable error) {
            String classname = this.getClass().getName();
            E2EBuilder.logger.severe("Doing errorhandling of " + classname + ". Cause: " + error.getClass().getName());
            E2EBuilder.logger.throwing(classname, "doErrorHandling", error);
            return true;
        }

        public void setProjectToLoad(E2EBuilderProject project) {
            this.description = "Loading Scheer PAS Builder Project " + project.getName();
        }
    }

    public class CloseProjectExecuter
    implements EventExecuter {
        public void execute(EventObject event) {
            E2EBuilder.logger.entering(this.getClass().getName(), "execute");
        }
    }

    public class SaveProjectAsExecuter
    implements EventExecuter {
        public void execute(EventObject event) {
            E2EBuilder.logger.entering(this.getClass().getName(), "execute");
        }
    }

    public class SaveProjectExecuter
    implements EventExecuter {
        public void execute(EventObject event) {
            ProjectSerializer.serialize(ProjectPool.this.actualProject);
        }
    }
}

