/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.plugin.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.TransactionParticipant;
import ch.e2e.builder.base.application.abstracts.AddTransactionParticipantEvent;
import ch.e2e.builder.base.application.abstracts.ModuleReleasedEvent;
import ch.e2e.builder.base.application.abstracts.ModuleShownEvent;
import ch.e2e.builder.base.application.abstracts.SelectMenuItemEvent;
import ch.e2e.builder.base.application.abstracts.StatusHandler;
import ch.e2e.builder.base.event.RefreshEvent;
import ch.e2e.builder.base.event.ToggleMessageViewEvent;
import ch.e2e.builder.base.gui.MessagePane;
import ch.e2e.builder.base.gui.MessagesParentWindow;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.plugin.gui.RegisterStatusHandlerEvent;
import ch.e2e.builder.base.plugin.gui.SetFrameWaitStateEvent;
import ch.e2e.builder.base.plugin.module.ModuleActivatedEvent;
import ch.e2e.builder.base.plugin.module.ModuleFrame;
import ch.e2e.builder.base.plugin.module.ModulePlugin;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.logging.JavaConsole;
import ch.e2e.resource.Properties;
import ch.e2e.swing.SplitPane;
import ch.e2e.swing.StatusBar;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame
implements ModuleFrame,
TransactionParticipant,
ChangeListener,
MessagesParentWindow {
    private static HashMap<String, MainFrame> mainFrames = new HashMap();
    private HashMap<String, ModulePlugin> modules = new HashMap();
    private ModulePlugin activePlugin;
    private boolean active;
    private Component glasspane;
    private SplitPane splitPane;
    private StatusBar statusBar;
    private JComponent overview;
    private String title;
    private String frameKey;
    private String projectName;
    private MessagePane messages;
    private JSplitPane main;

    public MainFrame(String title, String frameKey) {
        super(title);
        this.frameKey = frameKey;
        this.title = title;
        this.setIconImage(E2EBuilderIcons.APPLICATION_ICON);
        this.setDefaultCloseOperation(1);
        this.glasspane = this.getGlassPane();
        this.glasspane.addMouseListener(new MouseAdapter(){});
        this.glasspane.addKeyListener(new KeyAdapter(){});
        this.glasspane.setCursor(Cursor.getPredefinedCursor(3));
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MainFrame.this.toggleMessageView((ToggleMessageViewEvent)((Object)event));
            }
        }, ToggleMessageViewEvent.class);
    }

    public static MainFrame getMainFrame(ModulePlugin plugin) {
        String frameKey = plugin.getFrameKey();
        String title = plugin.getModule().getTranslation(frameKey, frameKey);
        MainFrame mainframe = mainFrames.get(frameKey);
        if (mainframe == null) {
            mainframe = new MainFrame(title, frameKey);
            mainFrames.put(frameKey, mainframe);
        }
        return mainframe;
    }

    public static void finalizeInitialization() {
        for (MainFrame frame : mainFrames.values()) {
            Properties properties;
            String prefix;
            if (frame.modules.size() == 1) {
                prefix = "";
                properties = frame.getModule().getProperties();
            } else {
                prefix = frame.frameKey + '.';
                properties = E2EBuilder.getInstance().getProperties();
            }
            frame.initialize();
            MainFrame.setVisibility(frame, properties, prefix);
            MainFrame.setBounds(frame, properties, prefix);
        }
    }

    public void addModule(ModulePlugin module) {
        this.modules.put(module.getModule().getTitle(), module);
    }

    public void initialize() {
        this.createGui();
        this.addEventHandler();
        this.addKeyBindings();
        for (ModulePlugin plugin : this.modules.values()) {
            EventController.fire((EventObject)new RegisterStatusHandlerEvent(this, plugin.getModule(), new StatusHandler(){

                @Override
                public void showStatus(E2EBuilderModule module, String message, String section) {
                    MainFrame.this.statusBar.setText(message, section);
                }
            }));
            EventController.fire((EventObject)(this.activePlugin.equals(plugin) ? new ModuleShownEvent(this, plugin.getModule()) : new ModuleReleasedEvent(this, plugin.getModule())));
        }
    }

    @Override
    public void setVisibility(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.activePlugin.windowOpened();
        } else {
            this.activePlugin.windowClosed();
        }
        this.saveVisibility(visible);
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.setTitle(this.title + ": " + this.activePlugin.getModule().getTitle() + " - " + projectName);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.activePlugin.getModule();
    }

    @Override
    public void transactionStarts() {
        this.active = this.isActive();
    }

    @Override
    public void transactionStarted() {
        if (this.active) {
            this.toFront();
            this.glasspane.setVisible(true);
        }
    }

    @Override
    public void transactionFinished() {
        if (this.active) {
            this.toFront();
        }
        this.glasspane.setVisible(false);
    }

    @Override
    public boolean isRemoveAfterAction() {
        return false;
    }

    @Override
    public Cursor getCursor() {
        return super.getCursor();
    }

    public int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    private void setDividerLocation(int width, int height) {
        int divider = (int)this.activePlugin.getModule().getProperties().getInteger("vertical_divider", 0L);
        if (divider == 0) {
            divider = width / 3;
        }
        this.splitPane.setDividerLocation(divider);
        divider = (int)this.activePlugin.getModule().getProperties().getInteger("messages.divider", 0L);
        if (divider == 0) {
            divider = 3 * height / 4;
        }
        this.main.setDividerLocation(divider);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ((JideTabbedPane)this.overview).removeChangeListener((ChangeListener)this);
        int index = ((JideTabbedPane)this.overview).getSelectedIndex();
        String moduleName = ((JideTabbedPane)this.overview).getTitleAt(index);
        if (this.activePlugin.getModule().remove()) {
            ModulePlugin newModule = this.modules.get(moduleName);
            boolean moduleChanged = false;
            if (newModule.getModule().show()) {
                this.saveDivider();
                moduleChanged = true;
                E2EBuilderModule oldModule = this.activePlugin.getModule();
                this.activePlugin = newModule;
                this.showActiveModule();
                oldModule.removed();
            }
            if (moduleChanged) {
                this.activePlugin.getModule().activated();
            }
        }
        ((JideTabbedPane)this.overview).setSelectedComponent((Component)this.activePlugin.getModule().getOverviewPanel());
        ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
        this.setTitle(this.title + ": " + this.activePlugin.getModule().getTitle() + " - " + this.projectName);
    }

    public ModulePlugin getActivePlugin() {
        return this.activePlugin;
    }

    public void saveStates() {
        Properties properties;
        String prefix;
        Rectangle bounds = this.getBounds();
        if (this.modules.size() == 1) {
            prefix = "";
            properties = this.getModule().getProperties();
        } else {
            prefix = this.frameKey + '.';
            properties = E2EBuilder.getInstance().getProperties();
        }
        properties.setProperty(prefix + "builder.plugin.frame.width", (long)bounds.width);
        properties.setProperty(prefix + "builder.plugin.frame.height", (long)bounds.height);
        properties.setProperty(prefix + "builder.plugin.frame.xpos", (long)bounds.x);
        properties.setProperty(prefix + "builder.plugin.frame.ypos", (long)bounds.y);
        this.saveDivider();
    }

    public void saveDivider() {
        if (this.activePlugin.getModule() != null) {
            int verticalDivider = this.splitPane.getDividerLocation();
            int horizontalDivider = this.main.getDividerLocation();
            this.activePlugin.getModule().getProperties().setProperty("vertical_divider", (long)verticalDivider);
            this.activePlugin.getModule().getProperties().setProperty("messages.divider", (long)horizontalDivider);
        }
    }

    private static void setVisibility(MainFrame frame, Properties properties, String prefix) {
        boolean visible = properties.getBoolean(prefix + "builder.plugin.frame.visible", false);
        frame.setVisibility(visible);
    }

    private static void setBounds(MainFrame frame, Properties properties, String prefix) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = new Rectangle();
        bounds.width = (int)properties.getInteger(prefix + "builder.plugin.frame.width", 0L);
        if (bounds.width == 0) {
            bounds.width = screenSize.width - screenSize.width / 3;
        }
        bounds.height = (int)properties.getInteger(prefix + "builder.plugin.frame.height", 0L);
        if (bounds.height == 0) {
            bounds.height = screenSize.height - screenSize.height / 4;
        }
        bounds.x = (int)properties.getInteger(prefix + "builder.plugin.frame.xpos", -1L);
        if (bounds.x == -1) {
            bounds.x = screenSize.width / 10;
        }
        bounds.y = (int)properties.getInteger(prefix + "builder.plugin.frame.ypos", -1L);
        if (bounds.y == -1) {
            bounds.y = screenSize.height / 5 + 10;
        }
        frame.setBounds(bounds);
        frame.setDividerLocation(bounds.width, bounds.height);
        SwingUtilities.updateComponentTreeUI(frame);
    }

    private void saveVisibility(boolean visible) {
        Properties properties;
        String prefix;
        if (this.modules.size() == 1) {
            prefix = "";
            properties = this.getModule().getProperties();
        } else {
            prefix = this.frameKey + '.';
            properties = E2EBuilder.getInstance().getProperties();
        }
        properties.setProperty(prefix + "builder.plugin.frame.visible", visible);
    }

    private void createGui() {
        this.getContentPane().setLayout(new BorderLayout());
        this.messages = new MessagePane(this);
        this.main = new JSplitPane(0);
        this.splitPane = new SplitPane(1);
        this.splitPane.setRealDividerSize(3);
        this.main.setTopComponent((Component)this.splitPane);
        this.main.setBottomComponent(this.messages);
        this.getContentPane().add((Component)this.main, "Center");
        this.statusBar = new StatusBar();
        this.statusBar.showTime("dd.MM.yyyy HH:mm", 60000);
        this.statusBar.addSection("status_messages");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.addModules();
    }

    private void addModules() {
        if (this.modules.size() == 1) {
            this.activePlugin = this.modules.values().iterator().next();
            this.overview = this.activePlugin.getModule().getOverviewPanel();
            this.messages.registerModule(this.activePlugin.getModule().getName());
            this.setTitle("E2EBuilder - " + this.activePlugin.getModule().getTitle());
        } else if (this.modules.size() > 0) {
            this.overview = new JideTabbedPane(1);
            ((JideTabbedPane)this.overview).setTabLayoutPolicy(1);
            this.activePlugin = this.createMultiModuleView();
            int index = -1;
            for (int i = 0; i < ((JideTabbedPane)this.overview).getTabCount() && index == -1; ++i) {
                if (!((JideTabbedPane)this.overview).getTitleAt(i).equals(this.activePlugin.getModule().getTitle())) continue;
                index = i;
            }
            ((JideTabbedPane)this.overview).setSelectedIndex(index);
            ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
        }
        if (this.overview != null) {
            this.splitPane.setLeftComponent((Component)this.overview);
            this.splitPane.setRightComponent((Component)this.activePlugin.getModule().getMainPanel());
            this.setMessagesVisible(this.activePlugin.getModule().getProperties().getBoolean("messages.visible", false));
        }
    }

    private ModulePlugin createMultiModuleView() {
        String lastModule;
        for (ModulePlugin plugin : this.modules.values()) {
            ((JideTabbedPane)this.overview).addTab(plugin.getModule().getTitle(), (Component)plugin.getModule().getOverviewPanel());
            this.messages.registerModule(plugin.getModule().getName());
        }
        ModulePlugin modulePlugin = null;
        try {
            lastModule = E2EBuilder.getInstance().getProperties().getString(this.frameKey + '.' + "last_module");
        }
        catch (MissingResourceException mrEx) {
            lastModule = ((JideTabbedPane)this.overview).getTitleAt(0);
        }
        Iterator<ModulePlugin> plugins = this.modules.values().iterator();
        while (plugins.hasNext() && modulePlugin == null) {
            ModulePlugin plugin = plugins.next();
            if (!plugin.getModule().getTitle().equals(lastModule)) continue;
            modulePlugin = plugin;
        }
        if (modulePlugin == null) {
            E2EBuilder.getInstance().getProperties().setProperty(this.frameKey + '.' + "last_module", lastModule);
            modulePlugin = this.modules.values().iterator().next();
        }
        return modulePlugin;
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                if (((ModuleActivatedEvent)event).getModule().equals(MainFrame.this.activePlugin)) {
                    MainFrame.this.setFrameVisible();
                }
            }
        }, ModuleActivatedEvent.class);
        EventController.fire((EventObject)new AddTransactionParticipantEvent(this, this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                E2EBuilder.getInstance().setParentFrame(MainFrame.this);
                E2EBuilder.getInstance().setActiveModule(MainFrame.this.getModule());
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.activePlugin.getModule().addProjectListener(new ProjectListener(){

            public void projectSettingsChange(ProjectEvent event) {
                MainFrame.this.setProjectName(event.getProject().getName());
            }

            public void doBeforeProjectOpen(ProjectEvent event) {
            }

            public void doAfterProjectOpen(ProjectEvent event) {
            }

            public void projectOpened(ProjectEvent event) {
            }

            public void doBeforeChanging(ProjectEvent event) {
            }
        });
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MainFrame.this.glasspane.setVisible(((SetFrameWaitStateEvent)event).isWait());
            }
        }, SetFrameWaitStateEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MainFrame.this.checkLicense();
            }
        }, CheckLicenseEvent.class);
    }

    private void setFrameVisible() {
        Properties properties;
        String prefix;
        if (this.modules.size() == 1) {
            prefix = "";
            properties = this.getModule().getProperties();
        } else {
            prefix = this.frameKey + '.';
            properties = E2EBuilder.getInstance().getProperties();
        }
        boolean visible = properties.getBoolean(prefix + "builder.plugin.frame.visible", false);
        this.setVisibility(visible);
    }

    private void addKeyBindings() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control F3"), "javaconsole.E2EBuilder.plugin." + this.getModule().getName());
        actionMap.put("javaconsole.E2EBuilder.plugin." + this.getModule().getName(), new AbstractAction("javaconsole.E2EBuilder.plugin." + this.getModule().getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaConsole.revertVisibility();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("F5"), "refresh.E2EBuilder.plugin." + this.getModule().getName());
        actionMap.put("refresh.E2EBuilder.plugin." + this.getModule().getName(), new AbstractAction("refresh.E2EBuilder.plugin." + this.getModule().getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventController.fire((EventObject)((Object)new RefreshEvent(this)));
                MainFrame.this.toFront();
            }
        });
    }

    private void showActiveModule() {
        this.splitPane.setRightComponent((Component)this.activePlugin.getModule().getMainPanel());
        this.setVerticalDivider();
        E2EBuilder.getInstance().getProperties().setProperty(this.activePlugin.getFrameKey() + '.' + "last_module", this.activePlugin.getModule().getTitle());
        this.messages.setActiveModule(this.activePlugin.getModule().getName());
        this.setMessagesVisible(this.activePlugin.getModule().getProperties().getBoolean("messages.visible", false));
    }

    private void setVerticalDivider() {
        int width;
        int maximumDivider;
        int verticalDivider = -1;
        if (this.activePlugin.getModule() != null) {
            verticalDivider = (int)this.activePlugin.getModule().getProperties().getInteger("vertical_divider", -1L);
        }
        int n = maximumDivider = (width = this.getBounds().width) > 0 ? width - 50 : (int)E2EBuilder.getInstance().getProperties().getInteger("width", 0L) - 50;
        if (verticalDivider == -1 || maximumDivider > 0 && verticalDivider > maximumDivider) {
            verticalDivider = this.getBounds().width / 3;
            this.saveDivider();
        }
        this.splitPane.setDividerLocation(verticalDivider);
    }

    private void checkLicense() {
        if (this.modules.size() == 1) {
            this.splitPane.setLeftComponent((Component)this.activePlugin.getModule().getOverviewPanel());
        } else if (this.modules.size() > 0) {
            ((JideTabbedPane)this.overview).removeChangeListener((ChangeListener)this);
            this.overview.removeAll();
            for (ModulePlugin plugin : this.modules.values()) {
                ((JideTabbedPane)this.overview).addTab(plugin.getModule().getTitle(), (Component)plugin.getModule().getOverviewPanel());
            }
            ((JideTabbedPane)this.overview).setSelectedComponent((Component)this.activePlugin.getModule().getOverviewPanel());
            ((JideTabbedPane)this.overview).addChangeListener((ChangeListener)this);
        }
        this.showActiveModule();
    }

    private void toggleMessageView(ToggleMessageViewEvent event) {
        if (this.messages.isModuleRegistered(event.getModule().getName())) {
            this.setMessagesVisible(event.getState());
        }
    }

    private void setMessagesVisible(boolean visible) {
        if (visible) {
            this.main.setBottomComponent(this.messages);
            this.setHorizontalDivider();
        } else {
            this.saveHorizontalDivider();
            this.main.setBottomComponent(null);
        }
        this.activePlugin.getModule().getProperties().setProperty("messages.visible", visible);
        EventController.fire((EventObject)new SelectMenuItemEvent(this, this.activePlugin.getModule(), new String[]{"menu.module", "menu.view.toggle.messageview"}, visible));
    }

    private void setHorizontalDivider() {
        int maximumDivider;
        int horizontalDivider = (int)this.activePlugin.getModule().getProperties().getInteger(this.activePlugin.getModule().getName() + "." + "messages.divider", -1L);
        int height = this.getBounds().height;
        int n = maximumDivider = height > 0 ? height - 50 : (int)this.activePlugin.getModule().getProperties().getInteger("height", 0L) - 50;
        if (horizontalDivider == -1 || maximumDivider > 0 && horizontalDivider > maximumDivider) {
            horizontalDivider = (int)(0.75 * (double)height);
        }
        this.main.setDividerLocation(horizontalDivider);
        this.saveHorizontalDivider();
    }

    private void saveHorizontalDivider() {
        int horizontalDivider;
        if (this.main.getBottomComponent() != null && (horizontalDivider = this.main.getDividerLocation()) > -1) {
            this.activePlugin.getModule().getProperties().setProperty("messages.divider", (long)horizontalDivider);
        }
    }
}

