/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.module;

import ch.e2e.builder.base.module.Info;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import java.util.MissingResourceException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ModuleInfo
implements Info {
    private Manifest manifest;
    private String title = "";
    private String shorttitle = "";
    private String name = "";
    private String description = "";
    private String version = "";
    private String build;
    private String date = "";
    private String vendor = "";
    private String copyright = "";
    private Icon icon = null;
    private Properties pluginInfo;
    private int tabOrder = 1000000;

    public ModuleInfo(Manifest manifest) {
        this.manifest = manifest;
        if (manifest == null) {
            this.fillDefaults("No manifest found");
        } else {
            String iconStr;
            Attributes attributes = manifest.getMainAttributes();
            this.name = attributes.getValue("Module-Name");
            this.title = attributes.getValue("Module-Title");
            if (this.title == null) {
                this.title = this.name;
            }
            this.shorttitle = attributes.getValue("Module-Shorttitle");
            if (this.shorttitle == null) {
                this.shorttitle = this.title;
            }
            this.description = attributes.getValue("Module-Info");
            if (this.description == null || this.description.length() == 0) {
                this.description = this.name;
            }
            this.version = attributes.getValue("Module-Version");
            this.build = attributes.getValue("Module-Build");
            if (this.build != null && !this.build.equals("")) {
                if (!this.build.startsWith("-") && !this.build.startsWith(".")) {
                    this.version = this.version + ".";
                }
                this.version = this.version + this.build;
            }
            this.date = attributes.getValue("Module-Date");
            this.vendor = attributes.getValue("Vendor");
            try {
                this.copyright = new String(attributes.getValue("Copyright").getBytes(), "UTF-8");
            }
            catch (Exception e) {
                this.copyright = attributes.getValue("Copyright") == null ? "" : attributes.getValue("Copyright");
            }
            char c = '\u00c2';
            if (this.copyright.indexOf(c) != -1) {
                this.copyright = this.copyright.replace(String.valueOf(c), "");
            }
            if ((iconStr = attributes.getValue("Module-Icon")) != null) {
                this.icon = ImageLoader.loadIcon((String)iconStr, (boolean)false, (ClassLoader)this.getClass().getClassLoader());
            }
            try {
                this.setTabOrder(Integer.valueOf(attributes.getValue("Module-Tab-Order")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ModuleInfo(String name) {
        this.fillDefaults(name);
    }

    private void fillDefaults(String name) {
        this.name = name;
        this.description = "";
        this.version = "";
        this.date = "";
        this.vendor = "";
        this.copyright = "";
    }

    public Attributes getAttributes(String name) {
        return this.manifest.getAttributes(name);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShorttitle() {
        return this.shorttitle;
    }

    public void setShorttitle(String shorttitle) {
        this.shorttitle = shorttitle;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuild() {
        return this.build;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? "" : this.copyright;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(String name) {
        this.icon = ImageLoader.loadIcon((String)name, (boolean)false, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public String getPluginTitle() {
        String title = null;
        if (this.pluginInfo != null) {
            title = this.pluginInfo.getString("Title", this.getName());
        }
        return title;
    }

    public String getPluginName() {
        String name = null;
        if (this.pluginInfo != null) {
            name = this.pluginInfo.getString("Name", "No name specified.");
        }
        return name;
    }

    @Override
    public String getPluginDescription() {
        String description = null;
        if (this.pluginInfo != null) {
            try {
                description = this.pluginInfo.getString("Info", this.getName());
            }
            catch (MissingResourceException e) {
                description = this.getPluginName();
            }
        }
        return description;
    }

    @Override
    public String getPluginVersion() {
        String version = null;
        if (this.pluginInfo != null) {
            version = this.pluginInfo.getString("Version", "No version information found.");
            String build = this.pluginInfo.getString("Build", "");
            if (build.length() > 0) {
                version = version + "." + build;
            }
        }
        return version;
    }

    @Override
    public String getPluginDate() {
        String date = null;
        if (this.pluginInfo != null) {
            date = this.pluginInfo.getString("Date", "No date information found.");
        }
        return date;
    }

    @Override
    public String getPluginVendor() {
        String vendor = null;
        if (this.pluginInfo != null) {
            vendor = this.pluginInfo.getString("Vendor", "No vendor information found.");
        }
        return vendor;
    }

    @Override
    public String getPluginCopyright() {
        String copyright = null;
        if (this.pluginInfo != null) {
            copyright = this.pluginInfo.getString("Copyright", "");
        }
        return copyright;
    }

    public Icon getPluginIcon() {
        String iconStr;
        ImageIcon icon = null;
        if (this.pluginInfo != null && (iconStr = this.pluginInfo.getProperty("Icon")) != null) {
            icon = ImageLoader.loadIcon((String)iconStr, (boolean)false, (ClassLoader)this.getClass().getClassLoader());
        }
        return icon;
    }

    public void addPluginInfo(Properties pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    @Override
    public boolean containsPluginInfo() {
        return this.pluginInfo != null;
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public void setTabOrder(int tabOrder) {
        this.tabOrder = tabOrder;
    }

    public String toString() {
        String result = this.title + '\n' + this.version + '\n' + this.date;
        if (this.pluginInfo != null) {
            result = result + '\n' + this.getPluginTitle() + '\n' + this.getPluginVersion() + '\n' + this.getPluginDate();
        }
        return result;
    }
}

