/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.menu;

import ch.e2e.builder.base.event.ToggleMenuEvent;
import ch.e2e.builder.base.gui.menu.E2EBuilderStandardMenu;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.event.ClearRecentProjectsEvent;
import ch.e2e.builder.base.project.event.OpenRecentProjectEvent;
import ch.e2e.builder.base.project.event.RecentProjectsEvent;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.event.MenuEventObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenuItem;

public class ReopenProjectMenu
extends E2EBuilderStandardMenu
implements EventExecuter {
    private Component clearSeparator;
    private ArrayList<String> recentProjects = new ArrayList();
    private JMenuItem clearItem;
    private ProjectPool projectPool;

    public ReopenProjectMenu(HashMap<String, MenuEventObject> menuEvents, ProjectPool projectPool) {
        super("menu.project.reopen", menuEvents);
        this.projectPool = projectPool;
        this.setIcon(E2EBuilderIcons.PROJECT_REOPEN_ICON);
        this.addEventHandler();
        this.addItems();
    }

    public void addItems() {
        this.addSeparator();
        this.clearSeparator = this.getMenuComponent(0);
        this.clearSeparator.setVisible(false);
        this.clearItem = this.addMenuItem("menu.project.reopen.clearlist", null, new ClearRecentProjectsEvent());
        this.addSeparator();
        JMenuItem openLastProjectMenu = this.addMenuItem("menu.project.reopen.open.startup", SELECTED_ICON, new ToggleMenuEvent());
        openLastProjectMenu.setSelected(this.projectPool.getOpenLastProject());
    }

    public void execute(EventObject event) {
        this.recentProjectsChanged(((RecentProjectsEvent)event).getRecentProjects());
    }

    private void recentProjectsChanged(ArrayList<String> recentProjects) {
        this.recentProjects.clear();
        this.recentProjects.addAll(recentProjects);
        this.setMenuItems();
    }

    private void setMenuItems() {
        int i;
        int length = this.getMenuComponentCount();
        for (i = 0; i < length - 4; ++i) {
            this.remove(0);
        }
        if (this.recentProjects.size() == 0) {
            this.clearSeparator.setVisible(false);
            this.clearItem.setEnabled(false);
        } else {
            this.clearSeparator.setVisible(true);
            this.clearItem.setEnabled(true);
            for (i = length = this.recentProjects.size() - 1; i > -1; --i) {
                String path = this.recentProjects.get(i);
                this.addMenuItem(path, PROJECT_ICON, new OpenRecentProjectEvent(path), 0);
            }
        }
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)this, RecentProjectsEvent.class);
    }
}

