/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.menu;

import ch.e2e.builder.base.gui.menu.E2EBuilderMenu;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleMenu;
import ch.e2e.builder.base.gui.menu.E2EBuilderStandardMenu;
import ch.e2e.builder.base.gui.menu.HelpMenu;
import ch.e2e.builder.base.gui.menu.PredefinedMenuItems;
import ch.e2e.builder.base.gui.menu.ProjectMenu;
import ch.e2e.builder.base.gui.menu.ViewMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.swing.event.MenuEventObject;
import com.jidesoft.action.CommandMenuBar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JMenu;

public class E2EBuilderMenuBar
extends CommandMenuBar
implements PredefinedMenuItems {
    private ArrayList<E2EBuilderMenu> menus = new ArrayList();
    private ArrayList<String> menuKeys = new ArrayList();
    private HashMap<String, MenuEventObject> menuEvents = new HashMap();

    public E2EBuilderMenuBar(String key, ProjectPool projectPool) {
        super(key);
        this.createGui(projectPool);
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    private void createGui(ProjectPool projectPool) {
        this.setInitSide(1);
        this.setInitIndex(0);
        this.setPaintBackground(false);
        this.setStretch(true);
        this.setFloatable(true);
        this.setHidable(false);
        E2EBuilderStandardMenu projectMenu = ProjectMenu.createProjectMenu(this.menuEvents, projectPool);
        this.add((E2EBuilderMenu)projectMenu, projectMenu.getKey());
        E2EBuilderStandardMenu viewMenu = ViewMenu.createViewMenu(this.menuEvents);
        this.add((E2EBuilderMenu)viewMenu, viewMenu.getKey());
        E2EBuilderStandardMenu helpMenu = HelpMenu.createHelpMenu(this.menuEvents);
        this.add((E2EBuilderMenu)helpMenu, helpMenu.getKey());
    }

    public void setModules(Iterator<E2EBuilderModule> modules) {
    }

    public void setVisible(String moduleName, boolean visible) {
        for (E2EBuilderMenu menu : this.menus) {
            menu.setVisible(moduleName, visible);
        }
    }

    public MenuEventObject getMenuEvent(String menuKey) {
        return this.menuEvents.get(menuKey);
    }

    public void setMenuEnabled(String menuName, boolean enabled) {
        int index = this.menuKeys.indexOf(menuName);
        if (index != -1) {
            this.menus.get(index).setEnabled(enabled);
        }
    }

    public Boolean isItemEnabled(String[] itemNames) {
        Boolean enabled = null;
        int index = this.menuKeys.indexOf(itemNames[0]);
        if (index != -1) {
            E2EBuilderMenu menu = this.menus.get(index);
            if (itemNames.length > 1) {
                String[] restItems = new String[itemNames.length - 1];
                System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
                enabled = menu.isItemEnabled(restItems);
            } else if (menu != null) {
                enabled = menu.isEnabled();
            }
        }
        return enabled;
    }

    public void setItemEnabled(String[] itemNames, boolean enabled) {
        int index = this.menuKeys.indexOf(itemNames[0]);
        if (index != -1) {
            E2EBuilderMenu menu = this.menus.get(index);
            if (itemNames.length > 1) {
                String[] restItems = new String[itemNames.length - 1];
                System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
                menu.setItemEnabled(restItems, enabled);
            } else {
                menu.setEnabled(enabled);
            }
        }
    }

    public Boolean isItemSelected(String[] itemNames) {
        Boolean selected = null;
        int index = this.menuKeys.indexOf(itemNames[0]);
        if (index != -1) {
            E2EBuilderMenu menu = this.menus.get(index);
            if (itemNames.length > 1) {
                String[] restItems = new String[itemNames.length - 1];
                System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
                selected = menu.isItemSelected(restItems);
            }
        }
        return selected;
    }

    public void setItemSelected(String[] itemNames, boolean selected) {
        int index = this.menuKeys.indexOf(itemNames[0]);
        if (index != -1) {
            E2EBuilderMenu menu = this.menus.get(index);
            if (itemNames.length > 1) {
                String[] restItems = new String[itemNames.length - 1];
                System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
                menu.setItemSelected(restItems, selected);
            }
        }
    }

    public void createMenuItem(String moduleName, String[] itemNames, Icon icon, MenuEventObject event, int index) {
        E2EBuilderMenu menu;
        int keyIndex = this.menuKeys.indexOf(itemNames[0]);
        if (keyIndex == -1) {
            menu = new E2EBuilderModuleMenu(itemNames[0], moduleName, this.menuEvents);
            this.add(menu, itemNames[0], false);
        } else {
            menu = this.menus.get(keyIndex);
        }
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            menu.createMenuItem(moduleName, restItems, icon, event, index);
        }
    }

    public void addSeparator(String moduleName, String[] menuNames) {
        E2EBuilderMenu menu;
        int index = this.menuKeys.indexOf(menuNames[0]);
        if (index == -1) {
            menu = new E2EBuilderModuleMenu(menuNames[0], moduleName, this.menuEvents);
            this.add(menu, menuNames[0], false);
        } else {
            menu = this.menus.get(index);
        }
        if (menuNames.length > 1) {
            String[] restMenus = new String[menuNames.length - 1];
            System.arraycopy(menuNames, 1, restMenus, 0, restMenus.length);
            menu.addSeparator(moduleName, restMenus);
        } else {
            menu.addSeparator(moduleName);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (E2EBuilderMenu menu : this.menus) {
            menu.setActivated(enabled);
        }
    }

    public void addMenus() {
        for (E2EBuilderMenu menu : this.menus) {
            this.add((JMenu)((Object)menu));
        }
    }

    public void setBuilderExpired(boolean expired) {
        int length = this.menuKeys.size();
        for (int i = 0; i < length; ++i) {
            String key = this.menuKeys.get(i);
            if (key.equals("menu.help")) continue;
            this.menus.get(i).setEnabled(!expired);
        }
    }

    public void add(E2EBuilderMenu menu, int index) {
        this.menuKeys.add(index, menu.getKey());
        this.menus.add(index, menu);
    }

    private void add(E2EBuilderMenu menu, String key) {
        this.menuKeys.add(key);
        this.menus.add(menu);
    }

    private void add(E2EBuilderMenu menu, String key, boolean visible) {
        menu.setVisible(visible);
        this.menuKeys.add(this.menuKeys.size() - 1, key);
        this.menus.add(this.menus.size() - 1, menu);
        if (this.getMenuCount() > 0) {
            this.removeAll();
            this.addMenus();
        }
    }
}

