/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.menu;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.event.ToggleMenuEvent;
import ch.e2e.builder.base.gui.menu.ActivatableItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderCheckBoxMenuItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenuItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleCheckBoxMenuItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleMenu;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleMenuComponent;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleMenuItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderModuleRadioButtonMenuItem;
import ch.e2e.builder.base.gui.menu.E2EBuilderRadioButtonMenuItem;
import ch.e2e.builder.base.gui.menu.PredefinedMenuItems;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.swing.event.MenuEventObject;
import com.jidesoft.swing.JideMenu;
import java.awt.Font;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public abstract class E2EBuilderMenu
extends JideMenu
implements PredefinedMenuItems,
E2EBuilderIcons {
    private HashMap<String, MenuEventObject> menuEvents;
    String key;
    private HashMap<String, JMenuItem> items = new HashMap();
    private boolean enabled = true;

    E2EBuilderMenu(String key, HashMap<String, MenuEventObject> menuEvents) {
        this(key, null, menuEvents);
    }

    E2EBuilderMenu(String key, Icon icon, HashMap<String, MenuEventObject> menuEvents) {
        this.key = key;
        if (icon != null) {
            this.setIcon(icon);
        }
        this.menuEvents = menuEvents;
    }

    public String getKey() {
        return this.key;
    }

    public void setText(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, ";", true);
            if (tokenizer.hasMoreTokens()) {
                super.setText(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        this.setMnemonic(tokenizer.nextToken().charAt(0));
                    }
                }
            }
        } else {
            super.setText("No entry definded");
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled);
        for (JMenuItem jMenuItem : this.items.values()) {
            ((ActivatableItem)((Object)jMenuItem)).setActivated(enabled);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.items != null) {
            for (JMenuItem jMenuItem : this.items.values()) {
                jMenuItem.setFont(font);
            }
        }
    }

    public void setActivated(boolean activated) {
        super.setEnabled(activated && this.enabled);
    }

    protected void add(JMenuItem menuItem, String key, boolean visible, int index) {
        menuItem.setVisible(visible);
        this.items.put(key, menuItem);
        index = index == -1 ? this.getMenuComponentCount() : index;
        this.add(menuItem, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createMenuItem(String moduleName, String[] itemNames, Icon icon, MenuEventObject event, int index) {
        E2EBuilderMenu menu;
        JMenuItem item = this.items.get(itemNames[0]);
        if (item == null) {
            if (event != null && itemNames.length <= 1) {
                this.addModuleMenuItem(itemNames[0], icon, moduleName, event, index);
                return;
            }
            menu = new E2EBuilderModuleMenu(itemNames[0], moduleName, this.menuEvents);
            this.items.put(itemNames[0], (JMenuItem)((Object)menu));
        } else {
            if (!(item instanceof E2EBuilderMenu)) {
                throw new RuntimeException("You could not add a menuitem on an other menuitem");
            }
            menu = (E2EBuilderMenu)((Object)item);
        }
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            menu.createMenuItem(moduleName, restItems, icon, event, index);
        }
    }

    public abstract void setVisible(String var1, boolean var2);

    public abstract void changeLanguage();

    public abstract void addSeparator(String var1);

    public abstract void addModuleMenuItem(String var1, Icon var2, String var3, MenuEventObject var4, int var5);

    public void addSeparator(String moduleName, String[] menuNames) {
        E2EBuilderMenu menu = (E2EBuilderMenu)((Object)this.items.get(menuNames[0]));
        if (menu == null) {
            menu = new E2EBuilderModuleMenu(menuNames[0], moduleName, this.menuEvents);
            this.items.put(menuNames[0], (JMenuItem)((Object)menu));
        }
        if (menuNames.length > 1) {
            String[] restItems = new String[menuNames.length - 1];
            System.arraycopy(menuNames, 1, restItems, 0, restItems.length);
            menu.addSeparator(moduleName, restItems);
        } else {
            menu.addSeparator(moduleName);
        }
    }

    public Boolean isItemEnabled(String[] itemNames) {
        Boolean enabled = null;
        JMenuItem item = this.items.get(itemNames[0]);
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            enabled = ((E2EBuilderMenu)((Object)item)).isItemEnabled(restItems);
        } else if (item != null) {
            enabled = item.isEnabled();
        }
        return enabled;
    }

    public void setItemEnabled(String[] itemNames, boolean enabled) {
        JMenuItem item = this.items.get(itemNames[0]);
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            ((E2EBuilderMenu)((Object)item)).setItemEnabled(restItems, enabled);
        } else if (item == null) {
            E2EBuilder.logger.warning("No menuitem defined for this path (" + itemNames[0] + ").");
        } else {
            item.setEnabled(enabled);
        }
    }

    public Boolean isItemSelected(String[] itemNames) {
        Boolean selected = null;
        JMenuItem item = this.items.get(itemNames[0]);
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            selected = ((E2EBuilderMenu)((Object)item)).isItemSelected(restItems);
        } else if (item != null) {
            selected = item.isSelected();
        }
        return selected;
    }

    public JMenuItem setItemSelected(String[] itemNames, boolean selected) {
        JMenuItem item = this.items.get(itemNames[0]);
        if (itemNames.length > 1) {
            String[] restItems = new String[itemNames.length - 1];
            System.arraycopy(itemNames, 1, restItems, 0, restItems.length);
            ((E2EBuilderMenu)((Object)item)).setItemSelected(restItems, selected);
        } else if (item == null) {
            E2EBuilder.logger.warning("No menuitem defined for this path (" + itemNames[0] + ").");
        } else {
            item.setSelected(selected);
        }
        return item;
    }

    JMenuItem addMenuItem(String key, Icon icon, MenuEventObject event, int index) {
        JMenuItem item = this.createMenuItem(key, icon, event);
        this.add(item, key, true, index);
        return item;
    }

    protected JMenuItem addMenuItem(String key, Icon icon, MenuEventObject event) {
        JMenuItem item = this.createMenuItem(key, icon, event);
        this.add(item, key, true, -1);
        return item;
    }

    JMenuItem createMenuItem(String key, Icon icon, MenuEventObject event) {
        Object menuItem;
        if (event instanceof ToggleMenuEvent) {
            ButtonGroup itemGroup = ((ToggleMenuEvent)event).getGroup();
            if (itemGroup == null) {
                menuItem = new E2EBuilderCheckBoxMenuItem(key, icon, (ToggleMenuEvent)event);
            } else {
                menuItem = new E2EBuilderRadioButtonMenuItem(key, icon, (ToggleMenuEvent)event);
                itemGroup.add((AbstractButton)menuItem);
            }
        } else {
            menuItem = new E2EBuilderMenuItem(key, icon, event);
        }
        if (event != null) {
            this.menuEvents.put(key, event);
        }
        return menuItem;
    }

    protected JMenuItem createModuleMenuItem(String key, Icon icon, String moduleName, MenuEventObject event) {
        E2EBuilderModuleMenuComponent menuItem;
        if (event instanceof ToggleMenuEvent) {
            ButtonGroup itemGroup = ((ToggleMenuEvent)event).getGroup();
            if (itemGroup == null) {
                menuItem = new E2EBuilderModuleCheckBoxMenuItem(key, icon, moduleName, (ToggleMenuEvent)event);
            } else {
                menuItem = new E2EBuilderModuleRadioButtonMenuItem(key, icon, moduleName, (ToggleMenuEvent)event);
                itemGroup.add((AbstractButton)((Object)menuItem));
            }
        } else {
            menuItem = new E2EBuilderModuleMenuItem(key, icon, moduleName, event);
        }
        this.menuEvents.put(key, event);
        return menuItem;
    }

    public HashMap<String, MenuEventObject> getMenuEvents() {
        return this.menuEvents;
    }

    public HashMap<String, JMenuItem> getItems() {
        return this.items;
    }
}

