/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ModuleDescriptionPanel
extends JPanel {
    public ModuleDescriptionPanel(E2EBuilderModule module) {
        super(new BorderLayout());
        String descriptionFile = module.getTranslation(module.getName() + ".module.description.page");
        if (descriptionFile == null) {
            descriptionFile = "No description found for module " + module.getTitle() + ".";
        }
        this.createGui(descriptionFile);
    }

    private void createGui(String descriptionFile) {
        JEditorPane htmlView = new JEditorPane();
        htmlView.setEditable(false);
        htmlView.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane scrollPane = new JScrollPane(htmlView, 20, 30);
        this.add((Component)scrollPane, "Center");
        this.setText(descriptionFile, htmlView);
    }

    private void setText(String descriptionFile, JEditorPane htmlView) {
        URL url = this.getClass().getClassLoader().getResource(descriptionFile);
        if (url == null) {
            htmlView.setText(descriptionFile);
            htmlView.getDocument().putProperty("stream", null);
        } else {
            try {
                htmlView.setPage(url);
            }
            catch (Exception e) {
                htmlView.setText(descriptionFile);
                htmlView.getDocument().putProperty("stream", null);
            }
        }
    }
}

