/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.resource.DialogStrings;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.MultiLineLabel;
import ch.e2e.swing.RegexTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class E2EBuilderInputDialog
extends ModalDialog
implements E2EBuilderIcons,
DialogStrings {
    private static HashMap<Window, E2EBuilderInputDialog> inputDialogs = new HashMap();
    private MultiLineLabel messageLabel;
    private ButtonGroup selectionGroup;
    private RegexTextField userInput;
    private ArrayList<String> selectedCheckboxes;

    protected E2EBuilderInputDialog(JFrame parent) {
        super((Frame)parent, E2EBuilderTranslator.getTranslation((String)"dialog.info.title"), E2EBuilderTranslator.getTranslation((String)"dialog.info.internaltitle", (String)""), E2EBuilderTranslator.getTranslation((String)"dialog.info.subtitle", (String)""), DIALOG_QUESTION_ICON, 3, false);
        this.init();
    }

    private E2EBuilderInputDialog(JDialog parent) {
        super((Dialog)parent, E2EBuilderTranslator.getTranslation((String)"dialog.info.title"), E2EBuilderTranslator.getTranslation((String)"dialog.info.internaltitle", (String)""), E2EBuilderTranslator.getTranslation((String)"dialog.info.subtitle", (String)""), DIALOG_QUESTION_ICON, 3, false);
        this.init();
    }

    private void init() {
        this.setLocale(Locale.ENGLISH);
        this.setLayout(new BorderLayout());
        this.messageLabel = new MultiLineLabel("");
        this.messageLabel.setHorizontalAlignment(2);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, null, false);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, false);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, AbstractButton additionalButton, int index) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, false, additionalButton, index);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, boolean ignoreEmptyString) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, ignoreEmptyString, null, -1);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, boolean ignoreEmptyString, String okButtonLabel, String cancelButtonLabel) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, ignoreEmptyString, okButtonLabel, cancelButtonLabel, null, -1);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, boolean ignoreEmptyString, AbstractButton additionalButton, int index) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, ignoreEmptyString, null, null, additionalButton, index);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, boolean ignoreEmptyString, String okButtonLabel, String cancelButtonLabel, AbstractButton additionalButton, int index) {
        return E2EBuilderInputDialog.getInput(message, defaultInput, title, internalTitle, subtitle, pattern, ignoreEmptyString, null, okButtonLabel, cancelButtonLabel, additionalButton, index);
    }

    public static String getInput(String message, String defaultInput, String title, String internalTitle, String subtitle, String pattern, boolean ignoreEmptyString, JPanel additionalPanel, String okButtonLabel, String cancelButtonLabel, AbstractButton additionalButton, int index) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderInputDialog inputDialog = E2EBuilderInputDialog.getInputDialog(title, internalTitle, subtitle);
        String result = null;
        inputDialog.createGui(message, defaultInput, pattern, ignoreEmptyString);
        if (additionalPanel != null) {
            inputDialog.add(additionalPanel, "Last");
        }
        String savedOkButtonLabel = null;
        if (okButtonLabel != null) {
            savedOkButtonLabel = inputDialog.getOkButtonText();
            inputDialog.setOkButtonText(okButtonLabel);
        }
        String savedCancelButtonLabel = null;
        if (cancelButtonLabel != null) {
            savedCancelButtonLabel = inputDialog.getCancelButtonText();
            inputDialog.setCancelButtonText(cancelButtonLabel);
        }
        if (additionalButton != null) {
            if (index == -1) {
                inputDialog.addButton(additionalButton, 2);
            } else {
                inputDialog.insertButton(additionalButton, index);
            }
        }
        SwingUtilities.updateComponentTreeUI((Component)((Object)inputDialog));
        String text = inputDialog.userInput.getText();
        if (text.length() == 0) {
            inputDialog.userInput.setCaretPosition(0);
        } else {
            inputDialog.userInput.setCaretPosition(text.length());
            inputDialog.userInput.setSelectionStart(0);
            inputDialog.userInput.setSelectionEnd(text.length());
        }
        int close = inputDialog.showDialog();
        if (close == 1) {
            result = inputDialog.userInput.getText();
        }
        if (additionalPanel != null) {
            inputDialog.remove(additionalPanel);
        }
        if (additionalButton != null) {
            inputDialog.removeButton(additionalButton);
        }
        if (savedOkButtonLabel != null) {
            inputDialog.setOkButtonText(savedOkButtonLabel);
        }
        if (savedCancelButtonLabel != null) {
            inputDialog.setCancelButtonText(savedCancelButtonLabel);
        }
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static String getSelection(String message, String[] selections, String defaultSelection, String title, String internalTitle, String subtitle) {
        E2EBuilderInputDialog inputDialog = E2EBuilderInputDialog.getInputDialog(title, internalTitle, subtitle);
        inputDialog.setOkButtonEnabled(true);
        String result = null;
        inputDialog.createGui(message, selections, defaultSelection);
        Enumeration<AbstractButton> radioButtons = inputDialog.selectionGroup.getElements();
        while (radioButtons.hasMoreElements()) {
            JRadioButton radioButton = (JRadioButton)radioButtons.nextElement();
            if (!radioButton.isSelected()) continue;
            radioButton.requestFocus();
        }
        int close = inputDialog.showDialog();
        if (close == 1) {
            result = inputDialog.selectionGroup.getSelection().getActionCommand();
        }
        return result;
    }

    public static String[] getSelections(String message, String[] selections, String[] defaultSelections, String title, String internalTitle, String subtitle) {
        return E2EBuilderInputDialog.getSelections(message, selections, defaultSelections, title, internalTitle, subtitle, false);
    }

    public static String[] getSelections(String message, String[] selections, String[] defaultSelections, String title, String internalTitle, String subtitle, boolean ignoreEmptySelection) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderInputDialog inputDialog = E2EBuilderInputDialog.getInputDialog(title, internalTitle, subtitle);
        inputDialog.selectedCheckboxes = new ArrayList();
        String[] result = null;
        inputDialog.createGui(message, selections, defaultSelections, ignoreEmptySelection);
        int close = inputDialog.showDialog();
        if (close == 1) {
            result = new String[inputDialog.selectedCheckboxes.size()];
            inputDialog.selectedCheckboxes.toArray(result);
        }
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    protected void createGui(String message, String defaultInput, String pattern, boolean ignoreEmptyString) {
        this.removeAll();
        this.messageLabel.setText(message);
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.messageLabel, "North");
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.userInput = new RegexTextField(pattern == null ? ".*" : pattern, 30);
        if (ignoreEmptyString) {
            this.setOkButtonEnabled(true);
        } else {
            this.setOkButtonEnabled(false);
            this.userInput.addInputFieldListener(new InputFieldListener(){

                public void inputFieldChanged(InputFieldEvent e) {
                    E2EBuilderInputDialog.this.setOkButtonEnabled(E2EBuilderInputDialog.this.userInput.getText().length() != 0);
                }
            });
        }
        this.userInput.setText(defaultInput);
        center.add((Component)this.userInput, "Center");
        this.userInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                E2EBuilderInputDialog.this.okDialog();
            }
        });
        this.add(center, "Center");
    }

    protected RegexTextField getUserInput() {
        return this.userInput;
    }

    private void createGui(String message, String[] selections, String[] defaultSelections, final boolean ignoreEmptySelection) {
        ArrayList<String> defaults = new ArrayList<String>();
        if (defaultSelections != null) {
            defaults.addAll(Arrays.asList(defaultSelections));
        }
        this.removeAll();
        this.messageLabel.setText(message);
        this.add((Component)this.messageLabel, "North");
        JPanel choicePanel = new JPanel(new GridLayout(0, 2));
        choicePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        for (String text : selections) {
            final JCheckBox cb = new JCheckBox(text);
            cb.setActionCommand(text);
            choicePanel.add(cb);
            if (defaults.contains(text)) {
                this.selectedCheckboxes.add(text);
                cb.setSelected(true);
            }
            this.selectionGroup.add(cb);
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (cb.isSelected()) {
                        E2EBuilderInputDialog.this.selectedCheckboxes.add(cb.getText());
                    } else {
                        E2EBuilderInputDialog.this.selectedCheckboxes.remove(cb.getText());
                        if (!ignoreEmptySelection) {
                            E2EBuilderInputDialog.this.setOkButtonEnabled(E2EBuilderInputDialog.this.selectedCheckboxes.size() != 0);
                        }
                    }
                }
            });
        }
        if (ignoreEmptySelection || this.selectedCheckboxes.size() != 0) {
            this.setOkButtonEnabled(true);
        } else {
            this.setOkButtonEnabled(false);
        }
        this.add(choicePanel, "Center");
    }

    private void createGui(String message, String[] selections, String defaultSelection) {
        this.removeAll();
        this.messageLabel.setText(message);
        this.add((Component)this.messageLabel, "North");
        this.setCancelButtonVisible(false);
        this.selectionGroup = new ButtonGroup();
        JPanel choicePanel = new JPanel(new GridLayout(0, 2));
        choicePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        AbstractButton firstButton = null;
        for (int i = 0; i < selections.length; ++i) {
            String text = selections[i];
            JRadioButton rb = new JRadioButton(text);
            if (i == 0) {
                firstButton = rb;
            }
            rb.setActionCommand(text);
            choicePanel.add(rb);
            if (defaultSelection != null && defaultSelection.equals(text)) {
                rb.setSelected(true);
            }
            this.selectionGroup.add(rb);
        }
        ButtonModel button = this.selectionGroup.getSelection();
        if (button == null && firstButton != null) {
            firstButton.setSelected(true);
        }
        this.add(choicePanel, "Center");
    }

    private static E2EBuilderInputDialog getInputDialog(String title, String internalTitle, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderInputDialog inputDialog = inputDialogs.get(parent);
        if (inputDialog == null) {
            inputDialog = parent instanceof JFrame ? new E2EBuilderInputDialog((JFrame)parent) : new E2EBuilderInputDialog((JDialog)parent);
            inputDialogs.put(parent, inputDialog);
        }
        inputDialog.setTitles(title, internalTitle, subtitle);
        return inputDialog;
    }

    protected void setTitles(String title, String internalTitle, String subtitle) {
        this.setTitle(title);
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
    }
}

