/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtils {
    private static final long DAY_IN_MS = 86400000L;

    public static boolean isToday(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static boolean isThisWeek(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static boolean isThisMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2);
    }

    public static boolean isThisQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1) && calendar2.get(2) / 3 == calendar.get(2) / 3;
    }

    public static boolean isThisYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) == calendar.get(1);
    }

    public static boolean isYesterday(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), -1);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static boolean isLastWeek(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), -7);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static boolean isLastMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2);
        if (n >= 1) {
            return calendar2.get(1) == calendar.get(1) && n - 1 == calendar.get(2);
        }
        return calendar2.get(1) - 1 == calendar.get(1) && calendar2.getActualMaximum(2) == calendar.get(2);
    }

    public static boolean isLastQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2) / 3;
        if (n >= 1) {
            return calendar2.get(1) == calendar.get(1) && n - 1 == calendar.get(2) / 3;
        }
        return calendar2.get(1) - 1 == calendar.get(1) && calendar2.getActualMaximum(2) / 3 == calendar.get(2) / 3;
    }

    public static boolean isLastYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) - 1 == calendar.get(1);
    }

    public static boolean isTomorrow(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), 1);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
    }

    public static boolean isNextWeek(Calendar calendar) {
        Calendar calendar2 = DateUtils.adjustDate(Calendar.getInstance(), 7);
        return calendar2.get(1) == calendar.get(1) && calendar2.get(3) == calendar.get(3);
    }

    public static boolean isNextMonth(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2);
        if (n < calendar2.getActualMaximum(2)) {
            return calendar2.get(1) == calendar.get(1) && n + 1 == calendar.get(2);
        }
        return calendar2.get(1) + 1 == calendar.get(1) && calendar2.getMinimum(2) == calendar.get(2);
    }

    public static boolean isNextQuarter(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        int n = calendar2.get(2) / 3;
        if (n < calendar2.getActualMaximum(2) / 3) {
            return calendar2.get(1) == calendar.get(1) && n + 1 == calendar.get(2) / 3;
        }
        return calendar2.get(1) + 1 == calendar.get(1) && calendar2.getActualMinimum(2) / 3 == calendar.get(2) / 3;
    }

    public static boolean isNextYear(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.get(1) + 1 == calendar.get(1);
    }

    public static boolean isAtMonth(Calendar calendar, int n) {
        return calendar.get(2) == n;
    }

    public static boolean isAtQuarter(Calendar calendar, int n) {
        return calendar.get(2) / 3 + 1 == n;
    }

    public static Calendar adjustDate(Calendar calendar, int n) {
        calendar.setTimeInMillis(calendar.getTimeInMillis() + 86400000L * (long)n);
        return calendar;
    }

    @Deprecated
    public static Date min(List<Date> list) {
        return DateUtils.minDates(list);
    }

    @Deprecated
    public static Date max(List<Date> list) {
        return DateUtils.maxDates(list);
    }

    public static Date minDates(List<Date> list) {
        long l = Long.MAX_VALUE;
        Date date = null;
        for (Date date2 : list) {
            long l2 = date2.getTime();
            if (l2 >= l) continue;
            l = l2;
            date = date2;
        }
        return date;
    }

    public static Date maxDates(List<Date> list) {
        long l = Long.MIN_VALUE;
        Date date = null;
        for (Date date2 : list) {
            long l2 = date2.getTime();
            if (l2 <= l) continue;
            l = l2;
            date = date2;
        }
        return date;
    }

    public static Calendar minCalendars(List<Calendar> list) {
        long l = Long.MAX_VALUE;
        Calendar calendar = null;
        for (Calendar calendar2 : list) {
            long l2 = calendar2.getTimeInMillis();
            if (l2 >= l) continue;
            l = l2;
            calendar = calendar2;
        }
        return calendar;
    }

    public static Calendar maxCalendars(List<Calendar> list) {
        long l = Long.MIN_VALUE;
        Calendar calendar = null;
        for (Calendar calendar2 : list) {
            long l2 = calendar2.getTimeInMillis();
            if (l2 <= l) continue;
            l = l2;
            calendar = calendar2;
        }
        return calendar;
    }
}

