/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class TintFilter
extends RGBImageFilter {
    private int _alpha;
    private int _red;
    private int _green;
    private int _blue;
    private int _width;
    private int _height;
    private Insets _insets;

    public TintFilter(Color color, int n, int n2, Insets insets) {
        this._alpha = color.getAlpha();
        this._red = color.getRed();
        this._green = color.getGreen();
        this._blue = color.getBlue();
        this._width = n;
        this._height = n2;
        this._insets = insets;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        if (this._insets != null && (n < this._insets.left || n > this._width - this._insets.right - 1 || n2 < this._insets.top || n2 > this._height - this._insets.bottom - 1)) {
            return n3;
        }
        Color color = new Color(n3, true);
        int n4 = Math.min(Math.max(color.getRed() + color.getRed() * this._red / 100, 0), 255);
        int n5 = Math.min(Math.max(color.getGreen() + color.getGreen() * this._green / 100, 0), 255);
        int n6 = Math.min(Math.max(color.getBlue() + color.getBlue() * this._blue / 100, 0), 255);
        int n7 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this._alpha / 100, 0), 255);
        return n7 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static Image createTintedImage(Image image, Color color, Insets insets) {
        TintFilter tintFilter = new TintFilter(color, image.getWidth(null), image.getHeight(null), insets);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), tintFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

