/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.parameter.JMSMessage;
import ch.e2e.bridge.server.jms.wrapper.BooleanMap;
import ch.e2e.bridge.server.jms.wrapper.ByteMap;
import ch.e2e.bridge.server.jms.wrapper.DoubleMap;
import ch.e2e.bridge.server.jms.wrapper.FloatMap;
import ch.e2e.bridge.server.jms.wrapper.IntegerMap;
import ch.e2e.bridge.server.jms.wrapper.LongMap;
import ch.e2e.bridge.server.jms.wrapper.ShortMap;
import ch.e2e.bridge.server.jms.wrapper.StringMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.NamingException;

public abstract class JMSMessageWrapper
extends Wrapper
implements JMSMessage {
    private Map longProperties;
    private Map byteProperties;
    private Map booleanProperties;
    private Map doubleProperties;
    private Map stringProperties;
    private Map integerProperties;
    private Map floatProperties;
    private Map shortProperties;

    public JMSMessageWrapper(ch.e2e.bridge.server.session.Session session) {
        super(session);
    }

    public JMSMessageWrapper(RecordItem recordItem, ch.e2e.bridge.server.session.Session session) {
        super(recordItem, session);
    }

    @Override
    public Message createMessage(Session session, JMSInitialContext initialContext) throws JMSException, NamingException {
        return null;
    }

    @Override
    public void fill(Object object) {
        if (object != null) {
            JMSMessage value = (JMSMessage)object;
            this.setLongProperties(value.getLongProperties());
            this.setByteProperties(value.getByteProperties());
            this.setBooleanProperties(value.getBooleanProperties());
            this.setDoubleProperties(value.getDoubleProperties());
            this.setStringProperties(value.getStringProperties());
            this.setIntegerProperties(value.getIntegerProperties());
            this.setFloatProperties(value.getFloatProperties());
            this.setShortProperties(value.getShortProperties());
            this.setJMSCorrelationID(value.getJMSCorrelationID());
            this.setJMSCorrelationIDAsBytes(value.getJMSCorrelationIDAsBytes());
            this.setJMSPersistentDeliveryMode(value.getJMSPersistentDeliveryMode());
            this.setJmsDestination(value.getJmsDestination());
            this.setJmsExpiration(value.getJmsExpiration());
            this.setJmsMessageID(value.getJmsMessageID());
            this.setJmsPriority(value.getJmsPriority());
            this.setJMSRedelivered(value.getJMSRedelivered());
            this.setJMSReplyTo(value.getJMSReplyTo());
            this.setJMSTimestamp(value.getJMSTimestamp());
            this.setJMSType(value.getJMSType());
        }
    }

    public void toObject(JMSMessage result) {
        result.setLongProperties(this.getLongProperties());
        result.setByteProperties(this.getByteProperties());
        result.setBooleanProperties(this.getBooleanProperties());
        result.setDoubleProperties(this.getDoubleProperties());
        result.setStringProperties(this.getStringProperties());
        result.setIntegerProperties(this.getIntegerProperties());
        result.setFloatProperties(this.getFloatProperties());
        result.setShortProperties(this.getShortProperties());
        result.setJMSCorrelationID(this.getJMSCorrelationID());
        result.setJMSCorrelationIDAsBytes(this.getJMSCorrelationIDAsBytes());
        result.setJMSPersistentDeliveryMode(this.getJMSPersistentDeliveryMode());
        result.setJmsDestination(this.getJmsDestination());
        result.setJmsExpiration(this.getJmsExpiration());
        result.setJmsMessageID(this.getJmsMessageID());
        result.setJmsPriority(this.getJmsPriority());
        result.setJMSRedelivered(this.getJMSRedelivered());
        result.setJMSReplyTo(this.getJMSReplyTo());
        result.setJMSTimestamp(this.getJMSTimestamp());
        result.setJMSType(this.getJMSType());
    }

    @Override
    public Map getLongProperties() {
        if (this.longProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(0);
            this.longProperties = (Map)arrayItem.fillArrayClass(Map.class, LongMap.class);
        }
        return this.longProperties;
    }

    @Override
    public void setLongProperties(Map longProperties) {
        this.longProperties = longProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(0);
        arrayItem.setValues(longProperties, LongMap.class);
    }

    @Override
    public Map getByteProperties() {
        if (this.byteProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
            this.byteProperties = (Map)arrayItem.fillArrayClass(Map.class, ByteMap.class);
        }
        return this.byteProperties;
    }

    @Override
    public void setByteProperties(Map byteProperties) {
        this.byteProperties = byteProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
        arrayItem.setValues(byteProperties, ByteMap.class);
    }

    @Override
    public Map getBooleanProperties() {
        if (this.booleanProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(2);
            this.booleanProperties = (Map)arrayItem.fillArrayClass(Map.class, BooleanMap.class);
        }
        return this.booleanProperties;
    }

    @Override
    public void setBooleanProperties(Map booleanProperties) {
        this.booleanProperties = booleanProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(2);
        arrayItem.setValues(booleanProperties, BooleanMap.class);
    }

    @Override
    public Map getDoubleProperties() {
        if (this.doubleProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(3);
            this.doubleProperties = (Map)arrayItem.fillArrayClass(Map.class, DoubleMap.class);
        }
        return this.doubleProperties;
    }

    @Override
    public void setDoubleProperties(Map doubleProperties) {
        this.doubleProperties = doubleProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(3);
        arrayItem.setValues(doubleProperties, DoubleMap.class);
    }

    @Override
    public Map getStringProperties() {
        if (this.stringProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(4);
            this.stringProperties = (Map)arrayItem.fillArrayClass(Map.class, StringMap.class);
        }
        return this.stringProperties;
    }

    @Override
    public void setStringProperties(Map stringProperties) {
        this.stringProperties = stringProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(4);
        arrayItem.setValues(stringProperties, StringMap.class);
    }

    @Override
    public Map getIntegerProperties() {
        if (this.integerProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(5);
            this.integerProperties = (Map)arrayItem.fillArrayClass(Map.class, IntegerMap.class);
        }
        return this.integerProperties;
    }

    @Override
    public void setIntegerProperties(Map integerProperties) {
        this.integerProperties = integerProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(5);
        arrayItem.setValues(integerProperties, IntegerMap.class);
    }

    @Override
    public Map getFloatProperties() {
        if (this.floatProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(6);
            this.floatProperties = (Map)arrayItem.fillArrayClass(Map.class, FloatMap.class);
        }
        return this.floatProperties;
    }

    @Override
    public void setFloatProperties(Map floatProperties) {
        this.floatProperties = floatProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(6);
        arrayItem.setValues(floatProperties, FloatMap.class);
    }

    @Override
    public Map getShortProperties() {
        if (this.shortProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(7);
            this.shortProperties = (Map)arrayItem.fillArrayClass(Map.class, ShortMap.class);
        }
        return this.shortProperties;
    }

    @Override
    public void setShortProperties(Map shortProperties) {
        this.shortProperties = shortProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(7);
        arrayItem.setValues(shortProperties, ShortMap.class);
    }

    @Override
    public String getJMSCorrelationID() {
        StringItem stringItem = this.getRecordItem().getStringItem(8);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setJMSCorrelationID(String value) {
        if (value != null) {
            this.setValue(8, value);
        }
    }

    @Override
    public boolean getJMSPersistentDeliveryMode() {
        return this.booleanValue(9);
    }

    @Override
    public void setJMSPersistentDeliveryMode(boolean value) {
        this.setValue(9, value);
    }

    @Override
    public String getJmsDestination() {
        StringItem stringItem = this.getRecordItem().getStringItem(10);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setJmsDestination(String value) {
        this.setValue(10, value);
    }

    @Override
    public long getJmsExpiration() {
        return this.longValue(11);
    }

    @Override
    public void setJmsExpiration(long value) {
        this.setValue(11, value);
    }

    @Override
    public String getJmsMessageID() {
        StringItem stringItem = this.getRecordItem().getStringItem(12);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setJmsMessageID(String value) {
        this.setValue(12, value);
    }

    @Override
    public int getJmsPriority() {
        return this.intValue(13);
    }

    @Override
    public void setJmsPriority(int value) {
        this.setValue(13, value);
    }

    @Override
    public boolean getJMSRedelivered() {
        return this.booleanValue(14);
    }

    @Override
    public void setJMSRedelivered(boolean value) {
        this.setValue(14, value);
    }

    @Override
    public String getJMSReplyTo() {
        StringItem stringItem = this.getRecordItem().getStringItem(15);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setJMSReplyTo(String value) {
        this.setValue(15, value);
    }

    @Override
    public long getJMSTimestamp() {
        return this.longValue(16);
    }

    @Override
    public void setJMSTimestamp(long value) {
        this.setValue(16, value);
    }

    @Override
    public String getJMSType() {
        StringItem stringItem = this.getRecordItem().getStringItem(17);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setJMSType(String value) {
        if (value != null) {
            this.setValue(17, value);
        }
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] value) {
        if (value != null) {
            this.setValue(18, value);
        }
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        BlobItem blobItem = this.getRecordItem().getBlobItem(18);
        return blobItem == null ? null : blobItem.byteValues();
    }
}

