/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.BaseAction;
import ch.e2e.bridge.server.jms.impl.JMSMessageListenerPool;
import ch.e2e.bridge.server.jms.parameter.JMSListenerParameter;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSReceiveParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.session.Session;

public class ReceiveMessageAsynchronAction
extends BaseAction {
    private JMSMessageListenerPool listenerPool;
    private JMSMessageType messageType;
    private JMSSessionParameter sessionParameter;
    private JMSReceiveParameter receiveParameter;
    private PoolConfig poolConfig;

    public ReceiveMessageAsynchronAction(JMSListenerParameter listenerParameter, JMSMessageType messageType, JMSSessionParameter sessionParameter, JMSReceiveParameter receiveParameter, PoolConfig poolConfig) {
        super(messageType, sessionParameter);
        this.messageType = messageType;
        this.sessionParameter = sessionParameter;
        this.receiveParameter = receiveParameter;
        this.poolConfig = poolConfig;
    }

    @Override
    public void start() {
        this.initialConnect();
    }

    private void initialConnect() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReceiveMessageAsynchronAction.this.listenerPool = new JMSMessageListenerPool(ReceiveMessageAsynchronAction.this.poolConfig, ReceiveMessageAsynchronAction.this.messageType.getMessageType(), ReceiveMessageAsynchronAction.this.receiveParameter, ReceiveMessageAsynchronAction.this.sessionParameter);
                }
                catch (Exception e) {
                    throw new BridgeException("Exception initializing JMSListenerPool", e);
                }
            }
        }).start();
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        return false;
    }

    @Override
    public void shutdown() {
        JMSLogger.getInstance().debug("1", "JMS shutdownInternal start");
        if (this.listenerPool != null) {
            this.listenerPool.shutdown();
        }
        JMSLogger.getInstance().debug("1", "JMS shutdownInternal end");
    }
}

