/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.parameter.JMSWrapperException;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class JMSSessionFactory
extends BasePoolableObjectFactory<Session> {
    private Connection connection;
    private final JMSSessionParameter sessionParameter;

    public JMSSessionFactory(JMSSessionParameter sessionParameter) {
        this.sessionParameter = sessionParameter;
    }

    public Session makeObject() throws Exception {
        long time = new Date().getTime();
        try {
            Session session = this.connection.createSession(this.sessionParameter.getConnectionInfo().getTransacted(), this.sessionParameter.getConnectionInfo().getAcknowledgeMode());
            JMSLogger.getInstance().debug("11", String.format("JMSSessionFactory.makeObject: Creating session %s took %sms.", session, new Date().getTime() - time));
            return session;
        }
        catch (Exception e) {
            throw new JMSWrapperException(String.format("Creating session for '%s' failed: %s and took %dms.", this.sessionParameter.getConnectionInfo().getName(), e.getMessage(), new Date().getTime() - time));
        }
    }

    public void destroyObject(Session session) throws Exception {
        JMSLogger.getInstance().debug("12", String.format("JMSSessionFactory.destroyObject: Closing session [%s] ...", session == null ? "null" : session.toString()));
        try {
            if (session != null) {
                session.close();
            }
        }
        finally {
            super.destroyObject((Object)session);
        }
    }

    public void removeObject(Session session) throws Exception {
        super.destroyObject((Object)session);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

