/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractLogger {
    private final String domain = this.getClass().getPackage().getName();
    private final Logger logger = new Logger();

    public void debug(String code, String message) {
        this.log(5L, code, message);
    }

    public void debug(String code, Throwable e) {
        this.debug(code, AbstractLogger.printStackTrace(e));
    }

    public void debug(String code, String message, Throwable e) {
        this.debug(code, message == null ? AbstractLogger.printStackTrace(e) : String.format("%s\n%s", message, AbstractLogger.printStackTrace(e)));
    }

    public void info(String code, String message) {
        this.log(4L, code, message);
    }

    public void warning(String code, String message) {
        this.log(3L, code, message);
    }

    public void error(String code, String message) {
        this.log(2L, code, message);
    }

    public void error(String code, Throwable e) {
        this.error(code, null, e);
    }

    public void error(String code, String message, Throwable e) {
        this.error(code, message == null ? AbstractLogger.printStackTrace(e) : String.format("%s\n%s", message, AbstractLogger.printStackTrace(e)));
    }

    public void log(long level, String code, String message) {
        try {
            this.logger.log(level, "Internal", this.domain, code, message);
        }
        catch (UnsatisfiedLinkError le) {
            System.out.printf("[%s][%s][%s]%n", this.domain, code, message);
        }
    }

    public static String printStackTrace(Throwable e) {
        StringWriter w = new StringWriter();
        PrintWriter stream = new PrintWriter(w);
        e.printStackTrace(stream);
        AbstractLogger.printCauseStackTrace(e, stream);
        return w.toString();
    }

    private static void printCauseStackTrace(Throwable e, PrintWriter stream) {
        Throwable cause = e.getCause();
        if (cause != null) {
            stream.println("CAUSE:");
            do {
                cause.printStackTrace(stream);
            } while ((cause = cause.getCause()) != null);
        }
    }
}

