/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.tools;

import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class XmiIDFactory {
    private static XmiIDFactory ourInstance;
    private ArrayList<String> generatedIDs = new ArrayList();
    private String globalPrefix;
    private HashMap<String, HashSet<Integer>> idSets = new HashMap();

    public static synchronized XmiIDFactory getInstance() {
        if (ourInstance == null) {
            ourInstance = new XmiIDFactory();
        }
        return ourInstance;
    }

    public void reset() {
        for (HashSet<Integer> integers : this.idSets.values()) {
            integers.clear();
        }
        this.idSets.clear();
        this.generatedIDs.clear();
        this.globalPrefix = "";
    }

    public void setGlobalPrefix(String globalPrefix) {
        this.globalPrefix = globalPrefix.replace(' ', '_');
    }

    public String getXmiID(String key, String prefix) {
        return this.generateId(prefix, key.hashCode());
    }

    public String getXmiID(Object umlElement, String prefix) {
        return this.generateId(prefix, umlElement.hashCode());
    }

    private String generateId(String prefix, int hash) {
        String idPrefix = this.globalPrefix + prefix + '_';
        HashSet<Integer> ids = this.idSets.get(idPrefix);
        if (ids == null) {
            ids = new HashSet();
            this.idSets.put(idPrefix, ids);
        }
        while (ids.contains(hash)) {
            ++hash;
        }
        ids.add(hash);
        return this.prepareForMDUse(StringTools.append((String)(idPrefix + String.valueOf(hash)), (int)15, (char)'x'));
    }

    private String prepareForMDUse(String id) {
        return id.replace(' ', '_');
    }
}

