/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.licensing;

import ch.e2e.builder.base.licensing.ModuleLicense;
import ch.e2e.builder.base.tools.ClassRegistry;
import java.util.HashMap;

public abstract class LicenseValidator {
    public static final String LICENSE_VALIDATOR_KEY = "ch.e2e.builder.base.licensing.LicenseValidator";
    private static LicenseValidator validator;
    private HashMap<String, ModuleLicense> modules = new HashMap();

    protected LicenseValidator() {
    }

    public static LicenseValidator getInstance() {
        if (validator == null && (validator = (LicenseValidator)ClassRegistry.getInstance().getClass(LICENSE_VALIDATOR_KEY)) == null) {
            validator = new DefaultLicenseValidator();
        }
        return validator;
    }

    public abstract void reload();

    public abstract boolean isExpired();

    public boolean isModuleEnabled(String module) {
        return this.modules.containsKey(module) && this.modules.get(module).isValid();
    }

    private static class DefaultLicenseValidator
    extends LicenseValidator {
        private DefaultLicenseValidator() {
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public void reload() {
        }

        @Override
        public boolean isModuleEnabled(String module) {
            return true;
        }
    }
}

