/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class ErrorHelper {
    public static String createLocation(SAXParseException saxException) {
        StringBuffer location = new StringBuffer();
        if (saxException.getPublicId() != null && saxException.getPublicId().length() > 0) {
            location.append(saxException.getPublicId()).append(", ");
        }
        if (saxException.getSystemId() != null && saxException.getSystemId().length() > 0) {
            location.append(saxException.getSystemId()).append(", ");
        }
        location.append("line ").append(saxException.getLineNumber()).append(", ");
        location.append("column ").append(saxException.getColumnNumber());
        return location.toString();
    }

    private static String readString(Element parent, String xmlName) {
        Node node;
        String value = null;
        NodeList elements = parent.getElementsByTagName(xmlName);
        if (elements != null && elements.getLength() == 1 && (node = elements.item(0)).hasChildNodes()) {
            value = node.getFirstChild().getNodeValue();
        }
        return value;
    }

    private static Integer readInteger(Element parent, String xmlName) {
        Node element;
        Integer res = null;
        NodeList elements = parent.getElementsByTagName(xmlName);
        if (elements != null && elements.getLength() == 1 && (element = elements.item(0)).hasChildNodes()) {
            res = Integer.parseInt(element.getFirstChild().getNodeValue());
        }
        return res;
    }

    public static void appendLocation(Element parent, String location) {
        Element locationElement = parent.getOwnerDocument().createElement("Location");
        locationElement.appendChild(parent.getOwnerDocument().createTextNode(location));
        parent.appendChild(locationElement);
    }

    public static String readLocation(Element parent) {
        return ErrorHelper.readString(parent, "Location");
    }

    public static void appendOriginalElement(Element parent, String originalElement) {
        Element element = parent.getOwnerDocument().createElement("originalElement");
        element.appendChild(parent.getOwnerDocument().createTextNode(originalElement));
        parent.appendChild(element);
    }

    public static String readOriginalElement(Element parent) {
        return ErrorHelper.readString(parent, "originalElement");
    }

    public static void appendLine(Element parent, Integer value) {
        Element element = parent.getOwnerDocument().createElement("Line");
        element.appendChild(parent.getOwnerDocument().createTextNode(value + ""));
        parent.appendChild(element);
    }

    public static Integer readLine(Element parent) {
        return ErrorHelper.readInteger(parent, "Line");
    }

    public static void appendColumn(Element parent, Integer value) {
        Element element = parent.getOwnerDocument().createElement("Column");
        element.appendChild(parent.getOwnerDocument().createTextNode(value + ""));
        parent.appendChild(element);
    }

    public static Integer readColumn(Element parent) {
        return ErrorHelper.readInteger(parent, "Column");
    }

    public static String getText(Element textElement) {
        if (textElement.hasChildNodes()) {
            Node text = textElement.getFirstChild();
            return text.getNodeValue();
        }
        return null;
    }
}

