/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.BuilderException;
import ch.e2e.builder.base.error.ErrorHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public abstract class AbstractParserError
extends BuilderException {
    private String location;

    public AbstractParserError(SAXParseException saxException) {
        super(saxException);
        this.location = ErrorHelper.createLocation(saxException);
    }

    public AbstractParserError(Element element) {
        super(element);
        this.location = ErrorHelper.readLocation(element);
    }

    @Override
    public Element toNode(Document parent) {
        Element errorElement = super.toNode(parent);
        ErrorHelper.appendLocation(errorElement, this.location);
        return errorElement;
    }

    @Override
    public boolean equals(Object other) {
        boolean result = super.equals(other);
        if (!result || other != null && other instanceof AbstractParserError) {
            result = this.equals((AbstractParserError)other);
        }
        return result;
    }

    public boolean equals(AbstractParserError error) {
        return this.location.equals(error.location);
    }

    @Override
    public int hashCode() {
        String paramString = this.getParameter().toString();
        String hashString = this.getCode() + paramString + this.location;
        return hashString.hashCode();
    }
}

