/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.uml.module.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.process.CompileProcess;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class UmlTask
extends CacheAbleTask {
    private final String PROCESSES_KEY = UmlTask.class.getCanonicalName() + "__processes";
    private final String UML_DOCUMENT_FACTORY_KEY = UmlTask.class.getCanonicalName() + "__umlDocumentFactory";

    public UmlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> results = super.getBeforeSourceSet();
        results.add("project.xml");
        return results;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(".e2ebuilder");
        return result;
    }

    protected abstract String getUmlCompileTaskId();

    protected String getUmlDocumentName() {
        return this.getDestinationFileNameWithoutExtension() + ".xml";
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        CompileProcess process = this.getUmlCompileProcess(this.getUmlDocumentName());
        AbstractErrorHandler compileErrorHandler = process.run(this.getUmlCompileTaskId());
        compileErrorHandler.addTo(this.getErrorHandler());
    }

    private CompileProcess getUmlCompileProcess(String umlDocumentName) {
        UmlDocumentFactory umlDocumentFactory = this.getUmlDocumentFactory();
        UmlDocument umlDocument = umlDocumentFactory.getUmlDocumentByName(umlDocumentName);
        Map<String, CompileProcess> processes = this.getProcesses();
        CompileProcess res = processes.get(umlDocument.getUniqueId());
        if (res == null) {
            res = new CompileProcess(umlDocument, processes);
        }
        return res;
    }

    private Map<String, CompileProcess> getProcesses() {
        HashMap processes = this.getSourceManager().getCustomObject(this.PROCESSES_KEY);
        if (processes == null) {
            processes = new HashMap();
            this.getSourceManager().putCustomObject(this.PROCESSES_KEY, processes);
        }
        return processes;
    }

    private UmlDocumentFactory getUmlDocumentFactory() {
        Object umlDocumentFactory = this.getSourceManager().getCustomObject(this.UML_DOCUMENT_FACTORY_KEY);
        if (umlDocumentFactory == null) {
            umlDocumentFactory = new UmlDocumentFactory(new UmlDocumentCompilerSettings(this.getSourceManager().getWorkFolder()));
            this.getSourceManager().putCustomObject(this.UML_DOCUMENT_FACTORY_KEY, umlDocumentFactory);
        }
        return (UmlDocumentFactory)umlDocumentFactory;
    }
}

