/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.xsltinterface;

import ch.e2e.builder.compiler.Properties;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.xsltinterface.Logging;
import ch.e2e.builder.compiler.xsltinterface.XSLTOutput;
import ch.e2e.builder.eal.EALNode;
import ch.e2e.builder.eal.EALParser;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.util.StringTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XSLTInput
extends ch.e2e.builder.base.xsltinterface.XSLTInput
implements Logging {
    private static final String CHARSET_NAME = "utf-8";
    private static SimpleDateFormat buildTimeFormat = new SimpleDateFormat("EEE, MMM d, yyyy, HH:mm:ss z", Locale.ENGLISH);
    private static UmlDocument currentUmlDocument;
    private static ArrayList<String> createdWrapper;
    public static boolean statemachineManual;
    private static long buildTime;
    private static int ealTreeElementId;
    private static String wsdlImportSource;
    private static boolean targetFromNamespace;
    private static boolean innovatorBPMN;
    private static boolean processTailorBPMN;
    private static String importSource;
    private static boolean aliasForSimplifiedComponentDiagram;
    private static Map<String, UmlDocument> umlDocumentMap;
    private static ch.e2e.resource.Properties profilesStereotypeXmiIds;
    private static ch.e2e.resource.Properties UIPrototypingProfileStereotypeXmiIds;
    private static ch.e2e.resource.Properties BPMN2ProfileStereotypeXmiIds;

    public static void init() {
        XSLTInput.reset();
        buildTime = new Date().getTime();
    }

    public static void reset() {
        StringTools.clearHashes();
        createdWrapper.clear();
    }

    public static boolean isTraceEnabled() {
        return true;
    }

    public static int getTraceState() {
        return 1;
    }

    public static boolean executeStatemachineManual() {
        return statemachineManual && XSLTInput.isTraceEnabled();
    }

    public static String getBridgeBaseFileName() {
        return UmlDocumentFactory.getGlobalBridgeBaseFileName();
    }

    public static String getBridgeProfileFileName() {
        return UmlDocumentFactory.getGlobalBridgeProfileFileName();
    }

    public static boolean isOptimizeJavaScript() {
        return Boolean.valueOf(CompilerConstants.getProjectValue("optimize.java.script"));
    }

    public static boolean wrapperNeedsCreate(String wrapperName) {
        boolean result = false;
        if (!createdWrapper.contains(wrapperName)) {
            result = true;
            createdWrapper.add(wrapperName);
        }
        return result;
    }

    public static String getOverride() {
        String override = System.getProperty("ch.e2e.builder.compiler.override");
        return override == null ? "TRUE" : override.toUpperCase();
    }

    public static String getOverrideFilename() {
        return "override";
    }

    public static String getTemplatesURL() {
        return System.getProperty("ch.e2e.builder.compiler.templates.url");
    }

    public static String getProfilesURL() {
        return System.getProperty("ch.e2e.builder.compiler.profiles.url");
    }

    public static String getModelLibrariesURL() {
        return System.getProperty("ch.e2e.builder.compiler.model.libraries.url");
    }

    public static String getDevelopment() {
        return String.valueOf(Boolean.getBoolean("ch.e2e.builder.development")).toUpperCase();
    }

    public static void setCurrentXmiFile(UmlDocument currentUmlDocument) {
        XSLTInput.currentUmlDocument = currentUmlDocument;
    }

    public static UmlDocument getCurrentXmiFile(String taskId) {
        if (taskId == null) {
            return currentUmlDocument;
        }
        UmlDocument document = umlDocumentMap.get(taskId);
        if (document != null) {
            return document;
        }
        return currentUmlDocument;
    }

    public static void setCurrentXmiFile(UmlDocument currentUmlDocument, String taskId) {
        umlDocumentMap.put(taskId, currentUmlDocument);
    }

    public static void removeCurentXmiFile(String taskId) {
        umlDocumentMap.remove(taskId);
    }

    public static String getCurrentXmiFileID(String taskId) {
        return XSLTInput.getCurrentXmiFile(taskId) == null ? "noumldocument" : XSLTInput.getCurrentXmiFile(taskId).getUniqueId();
    }

    public static String getCurrentXmiFileID() {
        return XSLTInput.getCurrentXmiFileID(null);
    }

    public static String getCurrentXmiFileName(String taskId) {
        return XSLTInput.getCurrentXmiFile(taskId) == null ? "noumldocument" : CompilerConstants.getFilenameWithoutDocumentExtension(XSLTInput.getCurrentXmiFile(taskId).getOriginalFile().getName());
    }

    public static String getCurrentXmiFileName() {
        return XSLTInput.getCurrentXmiFileName(null);
    }

    public static String getSVGDiagramFilename(String xmiId, String taskId) {
        String result = null;
        if (XSLTInput.getCurrentXmiFile(taskId) != null) {
            File resourcesHome = XSLTInput.getCurrentXmiFile(taskId).getSettings().getResourceFolder();
            resourcesHome = new File(resourcesHome, XSLTInput.getCurrentXmiFile(taskId).getOriginalFile().getName());
            File file = new File(resourcesHome = new File(resourcesHome, "htdocs/svg"), ".diagrams.info");
            if (file.exists()) {
                try {
                    Document bpmnDiagramsDocument = DomUtilities.parse((File)file, (boolean)false, (boolean)false);
                    NodeList bpmnDiagrams = bpmnDiagramsDocument.getElementsByTagName("Diagram");
                    int length = bpmnDiagrams.getLength();
                    for (int i = 0; i < length && result == null; ++i) {
                        Element diagram = (Element)bpmnDiagrams.item(i);
                        if (!diagram.getAttribute("id").equals(xmiId)) continue;
                        result = diagram.getAttribute("filename");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result == null ? "" : result;
    }

    public static String getSVGDiagramFilename(String xmiId) {
        return XSLTInput.getSVGDiagramFilename(xmiId, null);
    }

    public static String getDocumentJavaPackage(String taskId) {
        String result;
        if (XSLTInput.getCurrentXmiFile(taskId) == null) {
            result = "noumldocument";
        } else {
            String name = CompilerConstants.getFilenameWithoutDocumentExtension(XSLTInput.getCurrentXmiFile(taskId).getOriginalFile().getName()).toLowerCase();
            StringBuffer packageName = new StringBuffer();
            if (Character.isJavaIdentifierStart(name.charAt(0))) {
                packageName.append(name.charAt(0));
            }
            int length = name.length();
            for (int i = 1; i < length; ++i) {
                if (!Character.isJavaIdentifierPart(name.charAt(i))) continue;
                packageName.append(name.charAt(i));
            }
            result = packageName.toString();
        }
        return result;
    }

    public static String getDocumentJavaPackage() {
        return XSLTInput.getDocumentJavaPackage(null);
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getRegion() {
        return Locale.getDefault().getCountry();
    }

    public static String getExistingXmi() {
        return System.getProperty("ch.e2e.compiler.document.import.statemachine.xmifile") == null ? "" : System.getProperty("ch.e2e.compiler.document.import.statemachine.xmifile");
    }

    public static String getWsdlImportSource() {
        return wsdlImportSource == null ? "" : wsdlImportSource;
    }

    private static void setWsdlImportSource(String wsdlImportSource) {
        XSLTInput.wsdlImportSource = wsdlImportSource;
    }

    public static String getImportSource() {
        return importSource == null ? "" : importSource;
    }

    public static void setImportSource(String importSource) {
        XSLTInput.importSource = importSource;
        XSLTInput.setWsdlImportSource(importSource);
    }

    public static String getHashCode(String stringToHash) {
        return StringTools.getHashCodeAndCache((String)stringToHash);
    }

    public static String getNewLine() {
        return System.getProperty("line.separator");
    }

    public static GroundedValue getCompilerInformation(XPathContext context) {
        Document infoDoc = DomUtilities.newDocument((String)"CompilerInformation");
        Element buildTime = infoDoc.createElement("BuildTime");
        Text time = infoDoc.createTextNode(buildTimeFormat.format(XSLTInput.buildTime));
        buildTime.appendChild(time);
        buildTime.setAttribute("millis", String.valueOf(XSLTInput.buildTime));
        infoDoc.getDocumentElement().appendChild(buildTime);
        Element compiler = infoDoc.createElement("Compiler");
        String version = new Properties().getProperty("version");
        compiler.setAttribute("version", version == null ? "" : version);
        infoDoc.getDocumentElement().appendChild(compiler);
        String installerVersion = System.getProperty("ch.e2e.builder.version");
        if (installerVersion != null) {
            Element builder = infoDoc.createElement("Builder");
            builder.setAttribute("version", installerVersion);
            String runtimeVersion = System.getProperty("ch.e2e.builder.runtime.version");
            builder.setAttribute("runtime", runtimeVersion);
            infoDoc.getDocumentElement().appendChild(builder);
        }
        GroundedValue result = XSLTInput.createValue(infoDoc, context);
        return result;
    }

    public static String getMagicDrawVersion() {
        return System.getProperty("ch.e2e.builder.magicdraw.import.version") == null ? "" : System.getProperty("ch.e2e.builder.magicdraw.import.version");
    }

    public static String getUIPath(String taskId) {
        String uipath = System.getProperty("ch.e2e.builder.compiler.ui.development.path");
        String result = uipath == null ? (XSLTInput.getCurrentXmiFile(taskId) == null ? null : new File(XSLTInput.getCurrentXmiFile(taskId).getDocumentWorkingFolder(), "htdocs/").getAbsolutePath()) : uipath;
        return result == null ? new File(System.getProperty("java.io.tmpdir"), "/e2e/htdocs").getAbsolutePath() : result;
    }

    public static String getUIPath() {
        return XSLTInput.getUIPath(null);
    }

    private static GroundedValue createValue(Document xmlElement, XPathContext context) {
        EmptySequence result;
        if (xmlElement == null) {
            result = EmptySequence.getInstance();
        } else {
            PipelineConfiguration pipelineConfiguration = XSLTInput.newPipelineConfiguration((XPathContext)context);
            StringWriter writer = new StringWriter();
            try {
                DomUtilities.serialize((Writer)writer, (Document)xmlElement, (boolean)false, (ClassLoader)XSLTInput.class.getClassLoader());
                InputSource source = new InputSource(new StringReader(writer.toString()));
                NodeInfo doc = Configuration.getConfiguration((XPathContext)context).buildDocumentTree((Source)new SAXSource(source)).getRootNode();
                result = new SequenceExtent((SequenceIterator)doc.iterateAxis(Axis.CHILD.getAxisNumber(), (NodeTest)AnyNodeTest.getInstance()));
            }
            catch (TransformerException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(XSLTInput.class.getName(), "", e);
                result = EmptySequence.getInstance();
            }
        }
        return result;
    }

    public static GroundedValue createEALTree(XPathContext context, String ealExpression, String umlLocation, String originalElement, String taskId) {
        InputStreamReader reader;
        XSLTInput.resetEalTreeElementId();
        try {
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(ealExpression.getBytes(CHARSET_NAME)), CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        SequenceExtent result = null;
        try {
            EALParser parserTree = new EALParser((Reader)reader);
            EALNode le = parserTree.EALScript();
            TinyBuilder builder = XSLTInput.createBuilder((XPathContext)context);
            builder.setLineNumbering(false);
            builder.startDocument(0);
            XSLTInput.traverseEALTree(context, builder, le);
            builder.endDocument();
            NodeInfo doc = builder.getCurrentRoot();
            result = new SequenceExtent((SequenceIterator)doc.iterateAxis(Axis.CHILD.getAxisNumber(), (NodeTest)AnyNodeTest.getInstance()));
        }
        catch (Throwable e) {
            String parameter = ealExpression.replace(';', ' ') + ";" + e.getMessage().replace('\n', ' ');
            XSLTOutput.sendMessage((String)"JVXSEALP01", (String)"error", (String)umlLocation, (String)originalElement, (String)parameter, (String)taskId);
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void traverseEALTree(XPathContext context, TinyBuilder builder, EALNode current) throws TransformerException {
        if (current != null) {
            XSLTInput.startElement((XPathContext)context, (TinyBuilder)builder, (String)current.toString());
            String attributeValue = current.getValue();
            if (attributeValue != null) {
                XSLTInput.addAttribute((XPathContext)context, (TinyBuilder)builder, (String)"value", (String)attributeValue);
            }
            XSLTInput.addAttribute((XPathContext)context, (TinyBuilder)builder, (String)"startLine", (String)(current.getStartLine() + ""));
            XSLTInput.addAttribute((XPathContext)context, (TinyBuilder)builder, (String)"start", (String)(current.getStart() + ""));
            for (int i = 0; i < current.jjtGetNumChildren(); ++i) {
                EALNode child = (EALNode)current.jjtGetChild(i);
                if (child == null) continue;
                XSLTInput.traverseEALTree(context, builder, child);
            }
            builder.endElement();
        }
    }

    public static GroundedValue tokenize(XPathContext context, String str, String separators) {
        return XSLTInput.tokenize(context, str, separators, false);
    }

    public static GroundedValue tokenize(XPathContext context, String str, String separators, boolean returnDelims) {
        try {
            TinyBuilder builder = XSLTInput.createBuilder((XPathContext)context);
            builder.startDocument(0);
            StringTokenizer st = new StringTokenizer(str, separators, returnDelims);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                XSLTInput.startElement((XPathContext)context, (TinyBuilder)builder, (String)"token");
                builder.characters((CharSequence)token, (Location)ExplicitLocation.UNKNOWN_LOCATION, 0);
                builder.endElement();
            }
            builder.endDocument();
            NodeInfo doc = builder.getCurrentRoot();
            return new SequenceExtent((SequenceIterator)doc.iterateAxis(Axis.CHILD.getAxisNumber(), (NodeTest)AnyNodeTest.getInstance()));
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(XSLTInput.class.getName(), "tokenize", e);
            return null;
        }
    }

    public static String replaceSubstring(String data, String search, String replace) {
        return StringTools.replaceAll((String)data, (String)search, (String)replace, (boolean)false);
    }

    public static String removeQuotes(String str, String beginQuote, String endQuote, String umlLocation, String msg) {
        if (str == null) {
            XSLTOutput.sendMessage((String)"JVXSREMQ01", (String)"error", (String)umlLocation, (String)msg);
            return str;
        }
        if (beginQuote == null || beginQuote.length() == 0) {
            XSLTOutput.sendMessage((String)"JVXSREMQ02", (String)"error", (String)umlLocation, (String)msg);
            return str;
        }
        if (endQuote == null || endQuote.length() == 0) {
            XSLTOutput.sendMessage((String)"JVXSREMQ03", (String)"error", (String)umlLocation, (String)msg);
            return str;
        }
        int beginCount = 0;
        int endCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == beginQuote.charAt(0)) {
                ++beginCount;
            }
            if (str.charAt(i) != endQuote.charAt(0)) continue;
            ++endCount;
        }
        if (beginCount != endCount || beginQuote.charAt(0) == endQuote.charAt(0) && beginCount % 2 != 0) {
            XSLTOutput.sendMessage((String)"JVXSREMQ04", (String)"error", (String)umlLocation, (String)(beginQuote + ";" + endQuote + ";" + msg));
            return str;
        }
        if (str.startsWith(beginQuote) && str.endsWith(endQuote) && str.length() >= 2) {
            return str.substring(1, str.length() - 1);
        }
        if (str.startsWith(beginQuote)) {
            XSLTOutput.sendMessage((String)"JVXSREMQ05", (String)"error", (String)umlLocation, (String)(endQuote + ";" + msg));
            return str;
        }
        if (str.endsWith(endQuote)) {
            XSLTOutput.sendMessage((String)"JVXSREMQ06", (String)"error", (String)umlLocation, (String)(beginQuote + ";" + msg));
            return str;
        }
        return str;
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static String getImageUrl(String image) {
        URL url = XSLTInput.class.getClassLoader().getResource(image);
        String imageUrl = url.toString();
        return imageUrl;
    }

    public static void resetEalTreeElementId() {
        ealTreeElementId = 0;
    }

    public static int generateEalTreeElementId() {
        return ealTreeElementId++;
    }

    public static void setTargetFromNamespace(boolean targetFromNamespace) {
        XSLTInput.targetFromNamespace = targetFromNamespace;
    }

    public static void setAliasForSimplifiedComponentDiagram(boolean aliasForSimplifiedComponentDiagram) {
        XSLTInput.aliasForSimplifiedComponentDiagram = aliasForSimplifiedComponentDiagram;
    }

    public static boolean isAliasForSimplifiedComponentDiagram() {
        return aliasForSimplifiedComponentDiagram;
    }

    public static String getProfilesStereotypeXmiId(String stereotypeName) {
        if (stereotypeName == null) {
            return null;
        }
        return profilesStereotypeXmiIds.getProperty(stereotypeName);
    }

    public static String getUIPrototypingProfileStereotypeXmiId(String stereotypeName) {
        if (stereotypeName == null) {
            return null;
        }
        return UIPrototypingProfileStereotypeXmiIds.getProperty(stereotypeName);
    }

    public static String getBPMN2ProfileStereotypeXmiId(String stereotypeName) {
        if (stereotypeName == null) {
            return null;
        }
        return BPMN2ProfileStereotypeXmiIds.getProperty(stereotypeName);
    }

    public static String relativizePaths(String from, String to) {
        return FileUtilities.getRelativePath((File)new File(to), (File)new File(from));
    }

    static {
        createdWrapper = new ArrayList();
        ealTreeElementId = 0;
        targetFromNamespace = true;
        umlDocumentMap = new HashMap<String, UmlDocument>();
        profilesStereotypeXmiIds = new ch.e2e.resource.Properties(XSLTInput.class.getResourceAsStream("profilesStereotypeXmiIds.properties"));
        UIPrototypingProfileStereotypeXmiIds = new ch.e2e.resource.Properties(XSLTInput.class.getResourceAsStream("UI_Prototyping_profile.properties"));
        BPMN2ProfileStereotypeXmiIds = new ch.e2e.resource.Properties(XSLTInput.class.getResourceAsStream("BPMN2_Profile.properties"));
    }
}

