/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import java.io.File;
import java.net.URI;
import java.util.HashMap;

public abstract class ModuleFactory {
    private HashMap<URI, Module> modules = new HashMap();
    private Helpers helpers;

    protected ModuleFactory(Helpers helpers) {
        this.helpers = helpers;
    }

    public Module createModule(String name) {
        return new Module(name, this.helpers);
    }

    public Module getModule(File file, String moduleId) {
        URI uri = file.toURI();
        Module result = this.modules.get(uri);
        if (result == null) {
            result = new Module(file.getName(), moduleId, this.helpers);
            result.setURI(uri);
            this.modules.put(uri, result);
        }
        return result;
    }

    public Module getModule(URI uri, Object moduleDescriptor) {
        Module result = this.modules.get(uri);
        if (result == null && (result = this.createModule(moduleDescriptor)) != null) {
            this.modules.put(uri, result);
        }
        return result;
    }

    public void reset() {
        this.modules.clear();
    }

    public abstract Module createModule(Object var1);
}

