/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Generalization
extends UmlElement {
    private UmlElement type;
    private UmlElement specific;

    public Generalization(UmlElement type, UmlElement specific, Helpers helpers) {
        super(helpers);
        this.type = type;
        this.specific = specific;
    }

    public UmlElement getTypeClass() {
        return this.type;
    }

    public UmlElement getSpecific() {
        return this.specific;
    }

    @Override
    public Map<String, BridgeAttribute> setupAttributesWithDerived() {
        return this.type.setupAttributesWithDerived();
    }

    @Override
    public Map<String, BridgeOperation> setupOperationsWithDerived() {
        return this.type.setupOperationsWithDerived();
    }

    @Override
    public List<TypedElement> getElements() {
        return this.type.getElements();
    }

    @Override
    public String getBaseclass() {
        return "Generalization";
    }

    @Override
    protected String getXMIElementName() {
        return "generalization";
    }

    @Override
    protected String getIdKey() {
        return this.type.getIdKey();
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public String getQualifiedName() {
        return this.type.getQualifiedName();
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getElementHelper().createGeneralizationReference(this);
    }

    public Element toXMI(UmlElement client, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element generalization = this.toXMI(ownerDocument, xmiIDFactory);
        generalization.removeAttribute("visibility");
        if (this.type.checkModule(client.getModule())) {
            generalization.setAttribute("general", this.type.getXmiID());
        } else {
            Element general = this.createModuleLink(this.type, "general", ownerDocument, xmiIDFactory);
            generalization.appendChild(general);
        }
        return generalization;
    }
}

