/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class DependencyClientContainer
extends ArrayList<DeploymentElement> {
    private static DependencyClientComparator comparator = new DependencyClientComparator();
    private int index = -1;

    @Override
    public void add(int index, DeploymentElement element) {
        this.addDependencyClient(element);
    }

    @Override
    public boolean add(DeploymentElement o) {
        return this.addDependencyClient(o);
    }

    public boolean addDependencyClient(DeploymentElement element) {
        boolean result = false;
        if (!this.contains(element)) {
            result = super.add(element);
            this.sort();
        }
        return result;
    }

    public void removeDependencyClient(DeploymentElement dependencyClient) {
        this.remove(dependencyClient);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean hasNextDependencyClient() {
        return this.size() - 1 > this.index;
    }

    public void next() {
        ++this.index;
    }

    public DeploymentElement getDependencyClient() {
        return (DeploymentElement)this.get(this.index);
    }

    public boolean isConnected(DeploymentElement supplier) {
        boolean result = false;
        int length = this.size();
        for (int i = 0; i < length && !result; ++i) {
            DeploymentElement client = (DeploymentElement)this.get(i);
            for (BridgeDependency dependency : client.getBridgeDependencies()) {
                result = dependency.getSupplier().equals(supplier);
            }
        }
        return result;
    }

    private void sort() {
        DeploymentElement[] stereotypes = new DeploymentElement[this.size()];
        this.toArray(stereotypes);
        Arrays.sort(stereotypes, comparator);
    }

    private static class DependencyClientComparator
    implements Comparator<DeploymentElement> {
        private DependencyClientComparator() {
        }

        @Override
        public int compare(DeploymentElement element1, DeploymentElement element2) {
            return element1.compareTo(element2);
        }
    }
}

