/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildListener;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.ComponentDiagram;
import ch.e2e.builder.compiler.uml.ComponentList;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.TreeObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ComponentContainer
extends UmlElement
implements TreeObject {
    public static final int COMPONENTS = 200001;
    private ComponentList deployables;
    private ComponentList backendServices;
    private ComponentList proxyServices;
    private String name;
    private boolean selectable;

    public ComponentContainer(ComponentDiagram parent, BridgeStereotype deployableStereotype, String name, String[] listNames, Helpers helpers) {
        super(helpers);
        this.setParent(parent);
        this.name = name;
        this.deployables = new ComponentList(deployableStereotype, listNames[0], 100000, this, helpers);
        this.backendServices = new ComponentList(this.getHelpers().getStereotypeFactory().getStereotype("BackendServer"), listNames[1], 100001, this, helpers);
        if (listNames.length == 3) {
            this.proxyServices = new ComponentList(this.getHelpers().getStereotypeFactory().getStereotype("E2EProxyServer"), listNames[2], 100002, this, helpers);
            this.selectable = false;
        } else {
            this.selectable = false;
        }
        this.checkSelectable();
    }

    public ClassifierElement getDeployables() {
        return this.deployables;
    }

    public ClassifierElement getBackendServices() {
        return this.backendServices;
    }

    public ClassifierElement getProxyServices() {
        return this.proxyServices;
    }

    @Override
    public int getType() {
        return 200001;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int result = 0;
        if (child.equals(this.deployables)) {
            result = 0;
        } else if (child.equals(this.backendServices)) {
            result = 1;
        } else if (child.equals(this.deployables)) {
            result = 2;
        }
        return result;
    }

    @Override
    public UmlElement getChild(int index) {
        ComponentList result = null;
        switch (index) {
            case 0: {
                result = this.deployables;
                break;
            }
            case 1: {
                result = this.backendServices;
                break;
            }
            case 2: {
                result = this.proxyServices;
            }
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return this.proxyServices == null ? 2 : 3;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.components.icon.gif", (boolean)true);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<UmlElement> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public BridgeStereotype getStereotype() {
        return null;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void setChildListener(ChildListener childListener) {
        if (this.proxyServices == null) {
            this.deployables.setChildListener(childListener);
            this.backendServices.setChildListener(childListener);
        }
    }

    public void checkSelectable() {
        this.deployables.setSelectable(this.proxyServices == null && this.deployables.getChildCount() > 0 || this.selectable);
        this.backendServices.setSelectable(this.proxyServices == null && this.deployables.getChildCount() > 0 || this.selectable);
        if (this.proxyServices != null) {
            this.proxyServices.setSelectable(false);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getBaseclass() {
        return "ComponentContainer";
    }

    public ArrayList<ClassifierElement> findChildrenOfTypes(ArrayList<BridgeStereotype> childTypes) {
        ArrayList<ClassifierElement> children = new ArrayList<ClassifierElement>();
        children.addAll(this.deployables.findChildrenOfTypes(childTypes));
        children.addAll(this.backendServices.findChildrenOfTypes(childTypes));
        if (this.proxyServices != null) {
            children.addAll(this.proxyServices.findChildrenOfTypes(childTypes));
        }
        return children;
    }

    public boolean canSkip(UmlElement currentElement) {
        boolean skip;
        boolean bl = skip = this.deployables.getChildren().size() > 0 && this.checkChildren(this.deployables.getChildren()) && this.checkChildren(this.backendServices.getChildren());
        if (this.proxyServices != null) {
            boolean bl2 = skip = skip && this.checkChildren(this.proxyServices.getChildren());
        }
        if (skip) {
            // empty if block
        }
        return skip;
    }

    public BridgeStereotype findRequiredNodeType(UmlElement currentElement) {
        ComponentList parentList;
        Object result = null;
        Iterator<UmlElement> children = this.deployables.getChildren().iterator();
        children = this.backendServices.getChildren().iterator();
        if (result != null && (parentList = this.findParentList(currentElement)).getStereotype().equals(result)) {
            result = null;
        }
        return result;
    }

    private ComponentList findParentList(UmlElement currentElement) {
        ComponentList parentList = null;
        UmlElement parent = currentElement;
        while (parent != null && parentList == null) {
            if (parent instanceof ComponentList) {
                parentList = (ComponentList)parent;
                continue;
            }
            parent = parent.getParent();
        }
        return parentList;
    }

    private boolean checkChildren(List<UmlElement> children) {
        boolean skip = true;
        int length = children.size();
        for (int j = 0; j < length && skip; ++j) {
            skip = children.get(j).isComplete();
        }
        return skip;
    }
}

