/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeConstraint;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.LeftListElement;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.resource.ImageLoader;
import java.util.EnumMap;
import javax.swing.Icon;

public class BridgeParameterDefinition
extends UmlElement
implements LeftListElement {
    private Multiplicity multiplicity;
    private Direction direction;
    private BridgeConstraint constraint;
    private static final EnumMap<Direction, Icon> ICONS = new EnumMap(Direction.class);
    private BridgeClass type;

    public BridgeParameterDefinition(String name, BridgeClass type, Direction direction, Multiplicity multiplicity, BridgeConstraint constraint, Helpers helpers) {
        super(name, new Comment("", helpers), helpers);
        this.type = type;
        this.direction = direction;
        this.multiplicity = multiplicity;
        this.constraint = constraint;
    }

    @Override
    public boolean isComplete() {
        return this.getName() != null;
    }

    @Override
    public boolean isRequired() {
        return this.multiplicity != null && this.multiplicity.isRequired();
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return this.multiplicity != null && this.multiplicity.multipleInstancesAllowed();
    }

    public boolean nameIsUserDefined() {
        boolean userDefined = false;
        if (this.getName() == null) {
            userDefined = true;
        } else if (this.direction != null) {
            userDefined = this.getName().equalsIgnoreCase(this.direction.toString());
        }
        return userDefined;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            super.setName(null);
        } else {
            super.setName(name);
        }
    }

    public BridgeClass getTypeClass() {
        return this.type;
    }

    public boolean isInputParameter() {
        return this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.INOUT);
    }

    public boolean isOutputParameter() {
        return this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.INOUT);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BridgeConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(BridgeConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public int compareTo(Object o) {
        int result = 0;
        if (o instanceof BridgeParameterDefinition) {
            result = this.getName().compareToIgnoreCase(((BridgeParameterDefinition)o).getName());
        }
        return result;
    }

    @Override
    public Icon getIcon() {
        Icon icon = this.type == null ? ICONS.get((Object)this.getDirection()) : BridgeParameterDefinition.getIcon(this.getDirection());
        return icon;
    }

    public static Icon getIcon(Direction direction) {
        Icon icon;
        switch (direction) {
            case IN: {
                icon = ICONS.get((Object)Direction.PIN_IN);
                break;
            }
            case OUT: {
                icon = ICONS.get((Object)Direction.PIN_OUT);
                break;
            }
            default: {
                icon = ICONS.get((Object)direction);
            }
        }
        return icon;
    }

    @Override
    public String toDisplayText() {
        return (this.getName() != null ? this.getName() : this.direction) + (this.type == null ? "" : ": " + this.type) + (this.getTypeStereotype() == null ? "" : " <<" + this.getTypeStereotype() + ">>");
    }

    public String getTypeStereotype() {
        Object spec;
        String typeStereotype = null;
        if (this.constraint != null && this.constraint.getName().equals("stereotype") && String.class.isInstance(spec = this.constraint.getSpecification())) {
            typeStereotype = spec.toString();
        }
        return typeStereotype;
    }

    static {
        ICONS.put(Direction.IN, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/actionstate.parameter.direction.in.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
        ICONS.put(Direction.OUT, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/actionstate.parameter.direction.out.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
        ICONS.put(Direction.INOUT, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/actionstate.parameter.direction.inout.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
        ICONS.put(Direction.PIN_IN, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/input.pin.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
        ICONS.put(Direction.PIN_OUT, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/output.pin.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
        ICONS.put(Direction.VALUE_IN, ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/value.pin.icon.gif", (boolean)true, (ClassLoader)BridgeParameterDefinition.class.getClassLoader()));
    }
}

