/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeClass
extends ClassifierElement
implements TypedElement {
    private LinkedHashMap<String, BridgeClass> realizations = new LinkedHashMap();
    private LinkedHashMap<String, BridgeClass> usedClasses = new LinkedHashMap();
    private boolean fromContext = false;
    private boolean anAbstract;

    public BridgeClass(BridgeStereotype stereotype, Helpers helpers) {
        super(stereotype, helpers);
    }

    public BridgeClass(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
        this.setQualifiedName(name);
        this.setName(name);
    }

    public static BridgeClass getUntypedClass(Helpers helpers) {
        return new BridgeClass("[no type]", new Comment("", helpers), null, helpers);
    }

    public boolean isUntyped() {
        return "[no type]".equals(this.getName());
    }

    @Override
    public String getBaseclass() {
        String baseclass = super.getBaseclass() == null ? (this.getStereotype() == null || this.getStereotype().getDefaultBaseclass() == null ? "Class" : this.getStereotype().getDefaultBaseclass()) : super.getBaseclass();
        return baseclass;
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element clazz = super.toXMI(ownerDocument, xmiIDFactory);
        this.fillClassElement(clazz, ownerDocument, xmiIDFactory);
        return clazz;
    }

    private void fillClassElement(Element clazz, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        clazz.setAttribute("isAbstract", String.valueOf(this.anAbstract));
        this.addRealizations(clazz, ownerDocument, xmiIDFactory);
        for (BridgeOperation operation : this.getOperations()) {
            if (!this.containsOperationDefinition(operation.getName())) continue;
            clazz.appendChild(operation.toXMI(ownerDocument, xmiIDFactory));
        }
        for (BridgeAttribute attribute : this.getAttributes()) {
            clazz.appendChild(attribute.toXMI(ownerDocument, xmiIDFactory));
        }
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element clazz = this.createXMIElement("nestedClassifier", ownerDocument, xmiIDFactory);
        this.appendChildXMIElements(ownerDocument, clazz, xmiIDFactory);
        this.fillClassElement(clazz, ownerDocument, xmiIDFactory);
        return clazz;
    }

    @Override
    protected UmlElement createReferenceObject(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        BridgeClass result = new BridgeClass(this.getName(), this.getDescription(), this.getStereotype(), this.getHelpers());
        result.setOperationsMap(this.getOperationsMap());
        result.setAttributesMap(this.getAttributesMap());
        return result;
    }

    @Override
    public BridgeClass getTypeClass() {
        return this;
    }

    @Override
    public void setTypeClass(BridgeClass type) {
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        throw new ArrayAccessException();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public String getSignature() {
        return " : " + this.getName();
    }

    public void addRealization(BridgeClass realization) {
        this.realizations.put(realization.getQualifiedName(), realization);
    }

    public Collection<BridgeClass> getRealizations() {
        return this.realizations.values();
    }

    public void addUsedClass(String usageName, BridgeClass used) {
        this.usedClasses.put(usageName, used);
    }

    public Collection<BridgeClass> getUsedClasses() {
        return this.usedClasses.values();
    }

    public BridgeClass getUsedClass(String usageName) {
        return this.usedClasses.get(usageName);
    }

    public Collection<String> getUsages() {
        return this.usedClasses.keySet();
    }

    @Override
    public List<Module> getAllUsedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        if (this.getModule() != null) {
            result.add(this.getModule());
        }
        for (BridgeOperation operation : this.getOperations()) {
            List<Module> allModules = operation.getAllUsedModules();
            for (Module module : allModules) {
                if (result.contains(module)) continue;
                result.add(module);
            }
        }
        for (BridgeAttribute child : this.getAttributes()) {
            BridgeClass type = child.getTypeClass();
            if (type == null || type.getModule() == null || result.contains(type.getModule())) continue;
            result.add(type.getModule());
        }
        for (Generalization generalization : this.getGenerals()) {
            if (generalization.getTypeClass().getModule() == null || result.contains(generalization.getTypeClass().getModule())) continue;
            result.add(generalization.getTypeClass().getModule());
        }
        for (BridgeClass clazz : this.realizations.values()) {
            if (clazz.getModule() == null || result.contains(clazz.getModule())) continue;
            result.add(clazz.getModule());
        }
        return result;
    }

    @Override
    public List<UmlElement> getAllChildrenUsingOtherModule() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (BridgeOperation operation : this.getOperations()) {
            List<UmlElement> allModules = operation.getAllChildrenUsingOtherModule();
            for (UmlElement module : allModules) {
                if (result.contains(module)) continue;
                result.add(module);
            }
        }
        for (BridgeAttribute child : this.getAttributes()) {
            BridgeClass type = child.getTypeClass();
            if (type == null || type.getModule() == null || result.contains(type)) continue;
            result.add(type);
        }
        for (Generalization generalization : this.getGenerals()) {
            if (generalization.getTypeClass().getModule() == null || result.contains(generalization.getTypeClass())) continue;
            result.add(generalization.getTypeClass());
        }
        for (BridgeClass clazz : this.realizations.values()) {
            if (clazz.getModule() == null || result.contains(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }

    protected boolean containsOperationDefinition(String name) {
        boolean operationAllowed = false;
        if (this.getStereotypes() == null || this.getStereotypes().size() == 0) {
            operationAllowed = true;
        } else {
            int length = this.getStereotypes().size();
            for (int i = 0; i < length && !operationAllowed; ++i) {
                BridgeStereotype stereotype = this.getStereotypes().get(i);
                operationAllowed = stereotype.getCustomization().isOperationAllowed(name);
            }
        }
        return operationAllowed;
    }

    private void addRealizations(Element clazz, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        for (BridgeClass bridgeClass : this.realizations.values()) {
            Element supplier;
            Element realization = ownerDocument.createElement("interfaceRealization");
            realization.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:InterfaceRealization");
            realization.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", xmiIDFactory.getXmiID(bridgeClass.toString(), "Interface"));
            Element client = ownerDocument.createElement("client");
            client.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
            realization.appendChild(client);
            if (this.checkModule(bridgeClass.getModule())) {
                realization.setAttribute("contract", bridgeClass.getXmiID());
                supplier = ownerDocument.createElement("supplier");
                supplier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", bridgeClass.getXmiID());
            } else {
                supplier = this.createModuleLink(bridgeClass, "supplier", ownerDocument, xmiIDFactory);
                realization.appendChild(supplier);
                Element contract = this.createModuleLink(bridgeClass, "contract", ownerDocument, xmiIDFactory);
                realization.appendChild(contract);
            }
            clazz.appendChild(realization);
        }
    }

    public void setAbstract(boolean anAbstract) {
        this.anAbstract = anAbstract;
    }
}

