/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ArtifactList;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildListener;
import ch.e2e.builder.compiler.uml.ComponentContainer;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.TreeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ArtifactContainer
extends UmlElement
implements TreeObject {
    public static final int ARTIFACTS = 200002;
    private ArtifactList deployables;
    private ArtifactList backendServices;
    private ArtifactList proxyServices;

    public ArtifactContainer(ComponentContainer classifier, UmlElement parent, String name, String[] listNames, Helpers helpers) {
        super(helpers);
        this.setParent(parent);
        this.setName(name);
        this.deployables = new ArtifactList(classifier.getDeployables(), 150000, this, listNames[0], helpers);
        this.deployables.setSelectable(true);
        this.backendServices = new ArtifactList(classifier.getBackendServices(), 150001, this, listNames[1], helpers);
        this.proxyServices = new ArtifactList(classifier.getProxyServices(), 150002, this, listNames[2], helpers);
    }

    public ArtifactList getDeployables() {
        return this.deployables;
    }

    public ArtifactList getBackendServices() {
        return this.backendServices;
    }

    public ArtifactList getProxyServices() {
        return this.proxyServices;
    }

    @Override
    public int getType() {
        return 200002;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int result = 0;
        if (child.equals(this.deployables)) {
            result = 0;
        } else if (child.equals(this.backendServices)) {
            result = 1;
        } else if (child.equals(this.deployables)) {
            result = 2;
        }
        return result;
    }

    @Override
    public UmlElement getChild(int index) {
        ArtifactList result = null;
        switch (index) {
            case 0: {
                result = this.deployables;
                break;
            }
            case 1: {
                result = this.backendServices;
                break;
            }
            case 2: {
                result = this.proxyServices;
            }
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return 3;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setChildListener(ChildListener dependencyListener) {
        this.deployables.setChildListener(dependencyListener);
        this.backendServices.setChildListener(dependencyListener);
        this.proxyServices.setChildListener(dependencyListener);
    }

    @Override
    public Icon getIcon() {
        return ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.artifacts.icon.gif", (boolean)true);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public BridgeStereotype getStereotype() {
        return null;
    }

    public boolean canSkip(UmlElement currentElement) {
        boolean skip;
        boolean bl = skip = this.deployables.getChildren().size() > 0 && this.checkChildren(this.deployables.getChildren()) && this.checkChildren(this.backendServices.getChildren()) && this.checkChildren(this.proxyServices.getChildren());
        if (skip) {
            BridgeStereotype nodeType = this.findRequiredNodeType(currentElement);
            ArtifactList parentList = this.findParentList(currentElement);
            if (nodeType == null) {
                ArrayList<BridgeStereotype> requiredChildren = this.findRequiredNodeChildren(parentList.getStereotype());
                for (UmlElement child : parentList.getChildren()) {
                    requiredChildren.remove(child.getStereotype());
                }
                skip = requiredChildren.size() == 0;
            } else {
                skip = this.isNodeTypeReachable(parentList, nodeType);
            }
        }
        return skip;
    }

    public BridgeStereotype findRequiredNodeType(UmlElement currentElement) {
        ArtifactList parentList;
        BridgeStereotype result = null;
        Iterator<UmlElement> children = this.deployables.getChildren().iterator();
        while (children.hasNext() && result == null) {
            result = ((DeploymentElement)children.next()).findRequiredNodeType();
        }
        children = this.backendServices.getChildren().iterator();
        while (children.hasNext() && result == null) {
            result = ((DeploymentElement)children.next()).findRequiredNodeType();
        }
        if (result != null && (parentList = this.findParentList(currentElement)).getStereotype().equals(result)) {
            result = null;
        }
        return result;
    }

    public boolean isNextNodeType(DeploymentElement currentElement, BridgeStereotype nodeType) {
        ArtifactList parentList = this.findParentList(currentElement);
        return parentList.equals((Object)this.deployables) && nodeType.equals(this.backendServices.getStereotype()) || parentList.equals((Object)this.backendServices) && nodeType.equals(this.proxyServices.getStereotype());
    }

    public ArrayList<BridgeStereotype> getRemainingNodeTypes(DeploymentElement currentElement) {
        ArrayList<BridgeStereotype> result = new ArrayList<BridgeStereotype>();
        ArtifactList parentList = this.findParentList(currentElement);
        if (parentList == null) {
            result = new ArrayList();
        } else if (parentList.equals((Object)this.deployables)) {
            result.add(this.backendServices.getStereotype());
            result.add(this.proxyServices.getStereotype());
        } else if (parentList.equals((Object)this.backendServices)) {
            result.add(this.proxyServices.getStereotype());
        }
        return result;
    }

    private boolean checkChildren(List<UmlElement> children) {
        boolean skip = true;
        int length = children.size();
        for (int j = 0; j < length && skip; ++j) {
            skip = children.get(j).isComplete();
        }
        return skip;
    }

    private boolean isNodeTypeReachable(ArtifactList parentList, BridgeStereotype nodeType) {
        boolean reachable = false;
        if (!nodeType.equals(this.deployables.getStereotype())) {
            reachable = parentList.equals((Object)this.deployables) || parentList.equals((Object)this.backendServices) && nodeType.equals(this.proxyServices.getStereotype());
        }
        return reachable;
    }

    private ArtifactList findParentList(UmlElement currentElement) {
        ArtifactList parentList = null;
        UmlElement parent = currentElement;
        while (parent != null && parentList == null) {
            if (parent instanceof ArtifactList) {
                parentList = (ArtifactList)parent;
                continue;
            }
            parent = parent.getParent();
        }
        return parentList;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    public void checkSelectable() {
        boolean selectable = this.deployables.getChildCount() > 0;
        int length = this.deployables.getChildren().size();
        for (int i = 0; selectable && i < length; ++i) {
            DeploymentElement child = (DeploymentElement)this.deployables.getChildren().get(i);
            selectable = child.isComplete();
        }
        this.backendServices.setSelectable(selectable);
        this.proxyServices.setSelectable(selectable);
    }

    public DeploymentElement findArtifact(UmlElement classifier) {
        DeploymentElement result = this.deployables.findArtifact(classifier);
        if (result == null) {
            result = this.backendServices.findArtifact(classifier);
        }
        if (result == null) {
            result = this.proxyServices.findArtifact(classifier);
        }
        return result;
    }

    @Override
    public String getBaseclass() {
        return "ArtifactContainer";
    }

    public ArrayList<BridgeStereotype> findRequiredNodeChildren(BridgeStereotype nodeType) {
        ArrayList<BridgeStereotype> result = this.findRequiredNodeChildren(this.deployables.getChildren(), nodeType);
        if (result == null) {
            result = this.findRequiredNodeChildren(this.backendServices.getChildren(), nodeType);
        }
        if (result == null) {
            result = this.findRequiredNodeChildren(this.proxyServices.getChildren(), nodeType);
        }
        return result;
    }

    private ArrayList<BridgeStereotype> findRequiredNodeChildren(List<UmlElement> children, BridgeStereotype nodeType) {
        ArrayList<BridgeStereotype> result = new ArrayList<BridgeStereotype>();
        int length = children.size();
        for (int i = 0; result.size() == 0 && i < length; ++i) {
            DeploymentElement child = (DeploymentElement)children.get(i);
            Iterator<BridgeStereotype> dependencies = child.getStereotype().getCustomization().getRequiredBridgeDependencies().iterator();
            while (dependencies.hasNext() && result.size() == 0) {
                DependencyCustomization customization;
                ArrayList<BridgeStereotype> nodeTypes;
                BridgeStereotype dependency = dependencies.next();
                if (child.containsDependency(dependency) || !(nodeTypes = (customization = (DependencyCustomization)dependency.getCustomization()).getSupplierNodeTypes()).contains(nodeType)) continue;
                result = customization.getSupplier(nodeType);
            }
            if (result.size() != 0) continue;
            result = this.findRequiredNodeChildren(child.getChildren(), nodeType);
        }
        return result;
    }
}

