/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.tools;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.builder.compiler.build.tasks.source.JavaResourceSource;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.Map;

public abstract class CompilerConstants {
    private static final String BRIDGE_RUNTIME_PLATFORM_WIN = "win";
    private static final String BRIDGE_RUNTIME_PLATFORM_LINUX = "linux";
    private static final String BRIDGE_RUNTIME_PLATFORM = System.getProperty("os.name").toLowerCase().contains("win") ? "win" : "linux";
    private static final String BRIDGE_RUNTIME_BINARIES_FOLDER_WIN = "bin/runtime/win/bin";
    private static final String BRIDGE_RUNTIME_BINARIES_FOLDER_LINUX = "bin/runtime/linux/bin";
    public static final String BRIDGE_RUNTIME_BINARIES_FOLDER = CompilerConstants.isWindows() ? "bin/runtime/win/bin" : "bin/runtime/linux/bin";
    private static final String BRIDGE_RUNTIME_EXECUTABLE_WIN = "bridgeserver.exe";
    private static final String BRIDGE_RUNTIME_EXECUTABLE_LINUX = "bridgeserver";
    public static final String BRIDGE_RUNTIME_EXECUTABLE = CompilerConstants.isWindows() ? "bridgeserver.exe" : "bridgeserver";
    public static final String BRIDGE_SERVER_HOME = "bin";
    public static final String ASYNCHRONOUS_TRACE_EXTENSION = ".asynchronous.trace";
    public static final String BREAKPOINTS_FILE_EXTENSION = ".breakpoints";
    public static final String BRIDGE_XMI_EXTENSION = ".bxmi";
    public static final String BRIDGE_XMI_WITH_IMPORTS_EXTENSION = ".bxmi.wi";
    public static final String CSV_EXTENSION = ".csv";
    public static final String DEPLOY_EXTENSION = ".deploy";
    public static final String DESCRIPTOR_COMPOSITE_EXPANSION = ".composite";
    public static final String DESCRIPTOR_LIBRARY_EXPANSION = ".library";
    public static final String DESCRIPTOR_EXTENSION = ".descriptor";
    public static final String E2E_RFC_EXTENSION = ".wsdl";
    public static final String ERRORLOG_EXTENSION = ".errors";
    public static final String EXMI_EXTENSION = ".exmi";
    public static final String HTMLFILE_EXTENSION = ".html";
    public static final String IMPORT_EXTENSION = ".import";
    public static final String IMPORTED_DOCUMENT_EXTENSION = ".import.xml";
    public static final String INSTANCELIST_EXTENSION = ".instance.list";
    public static final String JARFILE_EXTENSION = ".jar";
    public static final String JAVA_EXTENSION = ".java";
    public static final String JSONFILE_EXTENSION = ".json";
    public static final String MDZIPFILE_EXTENSION = ".mdzip";
    public static final String MODULES_EXTENSION = ".modules";
    public static final String PROPERTIES_FILE_EXTENSION = ".properties";
    public static final String REPOSITORY_COMPOSITE_EXTENSION = ".rep";
    public static final String REPOSITORY_LIBRARY_EXTENSION = ".lrep";
    public static final String SERVER_LOG_EXTENSION = ".log";
    public static final String SVGFILE_EXTENSION = ".svg";
    public static final String COMPOSITE_TABFILE_CONTAINER_EXTENSION = ".composite.tabfiles";
    public static final String LIBRARY_TABFILE_CONTAINER_EXTENSION = ".library.tabfiles";
    public static final String TABFILE_CONTAINER_EXTENSION = ".tabfiles";
    public static final String TABFILE_EXTENSION = ".tab";
    public static final String TEMPLATE_EXTENSION = ".template";
    public static final String TEMPLATE_RESOURCE_BASE_PATH = "ch/e2e/builder/compiler/build/tasks/model/templateProject/";
    public static final String SOURCE_TEMPLATE_RESOURCE_BASE_PATH = JavaResourceSource.resourceIdPrefix + "ch/e2e/builder/compiler/build/tasks/model/templateProject/";
    public static final String TEMPORARY_IMPORT_EXTENSION = ".e2e.temp.xml";
    public static final String TRACE_ALL_EXTENSION_PREFIX = ".trace";
    public static final String TRACE_OFF_EXTENSION_PREFIX = "";
    public static final String TRUE_TYPE_FONT_FILE_EXTENSION = ".ttf";
    public static final String TYPE_1_FONT_FILE_EXTENSION = ".pfm";
    public static final String VERSION_EXTENSION = ".version";
    public static final String WSDLFILE_EXTENSION = ".wsdl";
    public static final String WSDLFILE_TEMPLATE_EXTENSION = ".wsdl.template";
    public static final String EDMXFILE_EXTENSION = ".edmx";
    public static final String EDMXFILE_TEMPLATE_EXTENSION = ".edmx.template";
    public static final String XARFILE_EXTENSION = ".xar";
    public static final String XMIFILE_EXTENSION = ".xmi";
    public static final String XMLFILE_EXTENSION = ".xml";
    public static final String XML_ZIPFILE_EXTENSION = ".xml.zip";
    public static final String XSDFILE_EXTENSION = ".xsd";
    public static final String XSDFILE_TEMPLATE_EXTENSION = ".xsd.template";
    public static final String XSLFILE_EXTENSION = ".xsl";
    public static final String XSLTFILE_EXTENSION = ".xslt";
    public static final String YAMLFILE_EXTENSION = ".yaml";
    public static final String ASYNCHRONOUS_TRACE_TEMPLATE = "asynchronous.trace.template";
    public static final String DIAGRAMS_INFO_FILENAME = ".diagrams.info";
    public static final String DEPENDS_FILENAME = "depends";
    public static final String DEPLOY_FILENAME = "deploy.xml";
    public static final String DESCRIPTOR_FILENAME = "descriptor.xml";
    public static final String DOCUMENT_INFO_FILENAME = ".document.info";
    public static final String E2E_BRIDGE_BASE = "E2E Bridge Base";
    public static final String E2E_BRIDGE_PROFILE = "E2E Bridge Profile";
    public static final String E2E_PROCESS_TRACING = "E2E Process Tracing";
    public static final String E2E_PROCESS_TRACING_FILE = "E2E Process Tracing.xml";
    public static final String E2ETOOLS_JAR = "e2etools.jar";
    public static final String ID_FILE = ".xmi.id";
    public static final String INSPECTION_LIST_FILENAME = "inspection.list";
    public static final String JAVA_ADDON_JAR = "addon.jar";
    public static final String JAVASCRIPT_CONFIGURATION_FILENAME = "configuration.js";
    public static final String LIBRARY_INTERFACE = "library.interface";
    public static final String MODULE_INTERFACE = "module.interface";
    public static final String MODULES_FILENAME = "modules";
    public static final String SUBSTITUTIONS_FILENAME = "substitutions";
    public static final String PSTATE_DB_FILENAME = "pstate.db";
    public static final String PSTATE_TAB_FILENAME = "PersistentState.tab";
    public static final String SETTINGS_FILENAME = "settings.xml";
    public static final String BUILDER_CONFIGURATION_FILENAME = "builder.xml";
    public static final String CHANGED_SETTINGS_FILENAME = "changedSettings.xml";
    public static final String SETTINGS_VIEW_INFO_FILENAME = "settings.view.info.xml";
    public static final String SCHEDULER_TABFILE = "AddOns/CronTab/base.tab";
    public static final String TIMER_TABFILE = "AddOns/Timer/base.tab";
    public static final String TRACE_DB_FILENAME = "trace.db";
    public static final String WRAPPER_ANTFILE = "build.xml";
    public static final String WRAPPER_JAR = "wrapper.jar";
    public static final String WSDL_FILENAME = "services.wsdl";
    public static final String BACKUP_FOLDER = "backup";
    public static final String BINARIES_FOLDER = ".$bin";
    public static final String BATCH_SCRIPTS_FOLDER = "bin";
    public static final String DESCRIPTOR_FOLDER = "descriptor";
    public static final String DOCUMENTATION_PREFIX = "documentation/";
    public static final String ERROR_FOLDER = "errorlog";
    public static final String HTDOCS_PREFIX = "htdocs/";
    public static final String IMPORTS_FOLDER = "imports/";
    public static final String JARFILE_FOLDER = "jarfiles";
    public static final String JAVA_FOLDER = "java";
    public static final String JAVA_LIB_FOLDER = "java/lib/";
    public static final String JAVA_RESOURCE_FOLDER = "java/resources/";
    public static final String LIBRARIES_FOLDER = "libs";
    public static final String MODEL_LIBRARIES_PREFIX = "modelLibraries/";
    public static final String PROFILES_PREFIX = "profiles/";
    public static final String REPOSITORY_FOLDER = "repository";
    public static final String RESOURCE_FOLDER = "resource";
    public static final String RESOURCES_FOLDER = "resources";
    public static final String SERVER_LOG_FOLDER = "logs";
    public static final String SVG_FOLDER = "htdocs/svg";
    public static final String SWAGGER_FOLDER_PREFIX = "swagger/";
    public static final String TABFILE_FOLDER = "tabfiles";
    public static final String TABFILES_PREFIX = "tabfiles/";
    public static final String TEMPLATES_PREFIX = "templates/";
    public static final String WORK_FOLDER = Utilities.WORK_FOLDER;
    public static final String WRAPPER_JARFOLDER = "wrapper/lib";
    public static final String WRAPPER_SRCFOLDER = "wrapper/src";
    public static final String WRAPPER_WORKFOLDER = "wrapper";
    public static final String WSDL_FOLDER = "wsdl/";
    public static final String XSLTFILES_FOLDER = "xslt";
    public static final String XSLT_FOLDER = "xslt/";
    public static final String XSLT_LIB_FOLDER = "xslt/lib/";
    public static final String XSLT_SRC_FOLDER = "xslt/src/";
    public static final String E2E_BRIDGE_MAP_PACKAGE = "ch.e2e.bridge.map";
    public static final String ANY = "Any";
    public static final String ERROR_LIBRARY_REPOSITORY_NOT_FOUND = "error.library.repository.not.found";
    public static final String ERROR_LIBRARY_DIFFERENT_VERSION = "error.library.different.version";
    public static final String ERROR_LIBRARY_MISSING_BACKEND_DEPLOYMENT = "error.library.missing.backend.deployment";
    public static final String ERROR_FILE_NOT_FOUND = "error.file.not.found";
    public static final String ERROR_LIBRARY_OLD_COMPILER = "error.library.old.compiler";
    public static final String MINIMUM_SUPPORTED_COMPILER_VERSION = "6.0.17.1";
    public static final String SYSTEM_KEY_IMPORTED_STATEMACHINE_XMI = "ch.e2e.compiler.document.import.statemachine.xmifile";
    public static final String SYSTEM_KEY_BUILDER_SYSTEM_LIBRARY_PATH = "ch.e2e.builder.system.library.path";
    public static final String SYSTEM_KEY_PROJECT_DIR = "project.dir";
    public static final String SYSTEM_KEY_PROJECT_PREFIX = "ch.e2e.builder.compiler.";
    public static final String SYSTEM_KEY_PROJECT_SOURCE = "uml";
    public static final String SYSTEM_KEY_PROJECT_TRACE_STATE = "trace.state";
    public static final String SYSTEM_KEY_MAX_NESTING_LEVEL = "ch.e2e.builder.base.wsdl.import.max.nesting.level";
    public static final String PLACEHOLDER_ABSOLUTE_PATH = "absolute path";
    public static final String PLACEHOLDER_ATTRIBUTE_NAME = "attribute name";
    public static final String PLACEHOLDER_BPMN_DIAGRAM_NAME = "bpmn.diagram.name";
    public static final String PLACEHOLDER_BUILD_DATE = "build.date";
    public static final String PLACEHOLDER_BUILD_TIME = "build.time";
    public static final String PLACEHOLDER_BUILD_Type = "build.type";
    public static final String PLACEHOLDER_CLASSIFIER_NAME = "classifier name";
    public static final String PLACEHOLDER_CLASSNAME = "classname";
    public static final String PLACEHOLDER_COLUMN = "column";
    public static final String PLACEHOLDER_COMPOSITE = "composite.name";
    public static final String PLACEHOLDER_DEPLOYED_HOST = "deployedHost";
    public static final String PLACEHOLDER_DEPLOYMENT = "deployment.name";
    public static final String PLACEHOLDER_DOCUMENT = "document.name";
    public static final String PLACEHOLDER_DOCUMENTS = "documents.names";
    public static final String PLACEHOLDER_EDITOR_NAME = "editor name";
    public static final String PLACEHOLDER_ERROR_COUNT = "error.count";
    public static final String PLACEHOLDER_EXISTING_VERSION = "existing.version";
    public static final String PLACEHOLDER_EXISTING_BUILDTIME = "existing.buildtime";
    public static final String PLACEHOLDER_EXPECTED_VERSION = "expected.version";
    public static final String PLACEHOLDER_EXPECTED_BUILDTIME = "expected.buildtime";
    public static final String PLACEHOLDER_FILENAME = "filename";
    public static final String PLACEHOLDER_HOST = "host";
    public static final String PLACEHOLDER_ID = "id";
    public static final String PLACEHOLDER_INDEX = "index";
    public static final String PLACEHOLDER_LIBRARY_COMPILER = "library.compiler";
    public static final String PLACEHOLDER_LIBRARY_NAME = "library.name";
    public static final String PLACEHOLDER_LINE = "line";
    public static final String PLACEHOLDER_NAME = "name";
    public static final String PLACEHOLDER_MINIMUM_COMPILER = "compiler.minimum.version";
    public static final String PLACEHOLDER_NAMES = "names";
    public static final String PLACEHOLDER_OPERATION = "operation";
    public static final String PLACEHOLDER_OPERATION_NAME = "operation name";
    public static final String PLACEHOLDER_PARAMETER = "parameter";
    public static final String PLACEHOLDER_PARENT_NAME = "parent name";
    public static final String PLACEHOLDER_PORT = "port";
    public static final String PLACEHOLDER_POSITION = "position";
    public static final String PLACEHOLDER_PROJECT_NAME = "project.name";
    public static final String PLACEHOLDER_REPOSITORY = "repository";
    public static final String PLACEHOLDER_RESOURCE_NAME = "resource.name";
    public static final String PLACEHOLDER_SELECTED_VERSION = "selected.version";
    public static final String PLACEHOLDER_SELECTED_BUILDTIME = "selected.buildtime";
    public static final String PLACEHOLDER_SERVICE = "service name";
    public static final String PLACEHOLDER_TYPE_ID = "type.id";
    public static final String PLACEHOLDER_URL = "url";
    public static final String PLACEHOLDER_VERSION = "version";
    public static final String PLACEHOLDER_WARNING_COUNT = "warning.count";
    public static final String PLACEHOLDER_PROPERTY_NAME = "property.name";
    public static final String JAVA_SOURCE_HEADER = "/*\n * Scheer PAS\n * Copyright 2001-2013 Scheer PAS. All rights reserved.\n * Generated. Do not touch.\n */\n";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String FILEFILTER_DESCRIPTION_PREFIX = "filefilter.description";
    public static final String DISPLAY_VALUE_TRACE_ALL = "Trace All";
    public static final String DISPLAY_VALUE_TRACE_OFF = "Trace Off";
    public static final String OPTIMIZE_JAVA_SCRIPT = "optimize.java.script";

    protected CompilerConstants() {
    }

    public static String getFilenameWithoutDocumentExtension(String filename) {
        if (filename.endsWith(XMIFILE_EXTENSION)) {
            filename = filename.substring(0, filename.indexOf(XMIFILE_EXTENSION));
        } else if (filename.endsWith(XMLFILE_EXTENSION)) {
            filename = filename.substring(0, filename.indexOf(XMLFILE_EXTENSION));
        } else if (filename.endsWith(MDZIPFILE_EXTENSION)) {
            filename = filename.substring(0, filename.indexOf(MDZIPFILE_EXTENSION));
        } else if (filename.endsWith(XML_ZIPFILE_EXTENSION)) {
            filename = filename.substring(0, filename.indexOf(XML_ZIPFILE_EXTENSION));
        } else {
            int index = filename.lastIndexOf(46);
            if (index != -1) {
                filename = filename.substring(0, index);
            }
        }
        return filename;
    }

    public static String replaceURIProperties(String url, Map properties) {
        String drive;
        url = url.replace("%3C", "<");
        url = url.replace("%3E", ">");
        int index = url.indexOf(58);
        String protocol = url.substring(0, index + 1);
        url = url.substring(index + 1);
        while (url.startsWith("/")) {
            protocol = protocol + '/';
            url = url.substring(1);
        }
        index = url.indexOf(58);
        if (index == -1) {
            drive = TRACE_OFF_EXTENSION_PREFIX;
        } else {
            drive = url.substring(0, index + 2);
            url = url.substring(index + 2);
        }
        url = StringTools.replaceProperties((String)url, (Map)properties, (String)"<", (String)">");
        url = url.replace('\\', '/');
        url = url.replace("//", "/");
        url = url.replace(" ", "%20");
        url = url.replace("<", "%3C");
        url = url.replace(">", "%3E");
        url = drive.length() > 0 && url.indexOf(58) != -1 ? protocol + url : protocol + drive + url;
        url = url.replace("//", "/");
        return url;
    }

    public static String createClassName(String name) {
        String packageName;
        String className;
        name = name.replace('\\', '.');
        int index = (name = name.replace('/', '.')).lastIndexOf(46);
        if (index == -1) {
            className = name;
            packageName = TRACE_OFF_EXTENSION_PREFIX;
        } else {
            packageName = name.substring(0, index + 1).toLowerCase();
            className = name.substring(index + 1);
        }
        char first = Character.toUpperCase(className.charAt(0));
        name = packageName + first + className.substring(1);
        return name;
    }

    public static String getProjectValue(String key) {
        return System.getProperty(SYSTEM_KEY_PROJECT_PREFIX + key);
    }

    public static void setProjectValue(String key, String value) {
        if (value == null) {
            System.getProperties().remove(SYSTEM_KEY_PROJECT_PREFIX + key);
        } else {
            System.setProperty(SYSTEM_KEY_PROJECT_PREFIX + key, value);
        }
    }

    public static File getSourceFolder() {
        String sourceFolderString = CompilerConstants.getProjectValue(SYSTEM_KEY_PROJECT_SOURCE);
        File sourceFolder = null;
        if (sourceFolderString == null) {
            if (E2EBuilderProject.getProjectFolderName() != null) {
                File projectHome = new File(E2EBuilderProject.getProjectFolderName());
                sourceFolder = new File(projectHome, SYSTEM_KEY_PROJECT_SOURCE);
            }
        } else {
            sourceFolder = new File(sourceFolderString);
        }
        return sourceFolder;
    }

    public static boolean isInSrcPath(File file) {
        boolean inPath = false;
        if (CompilerConstants.getProjectValue(SYSTEM_KEY_PROJECT_SOURCE) != null) {
            File srcFolder = new File(CompilerConstants.getProjectValue(SYSTEM_KEY_PROJECT_SOURCE));
            for (File folder = file.getParentFile(); folder != null && !inPath; folder = folder.getParentFile()) {
                inPath = folder.equals(srcFolder);
            }
        }
        return inPath;
    }

    public static boolean isWindows() {
        return BRIDGE_RUNTIME_PLATFORM.equals(BRIDGE_RUNTIME_PLATFORM_WIN);
    }
}

